/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.acl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.acl.Policy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutablePolicy
extends Policy {
    @Nullable
    private final String id;
    @Nullable
    private final String description;
    private final String name;
    @Nullable
    private final String rules;
    @Nullable
    private final List<String> datacenters;

    private ImmutablePolicy(@Nullable String id, @Nullable String description, String name, @Nullable String rules, @Nullable List<String> datacenters) {
        this.id = id;
        this.description = description;
        this.name = name;
        this.rules = rules;
        this.datacenters = datacenters;
    }

    @Override
    @JsonProperty(value="ID")
    public Optional<String> id() {
        return Optional.ofNullable(this.id);
    }

    @Override
    @JsonProperty(value="Description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Rules")
    public Optional<String> rules() {
        return Optional.ofNullable(this.rules);
    }

    @Override
    @JsonProperty(value="Datacenters")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public Optional<List<String>> datacenters() {
        return Optional.ofNullable(this.datacenters);
    }

    public final ImmutablePolicy withId(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"id");
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new ImmutablePolicy(newValue, this.description, this.name, this.rules, this.datacenters);
    }

    public final ImmutablePolicy withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutablePolicy(value, this.description, this.name, this.rules, this.datacenters);
    }

    public final ImmutablePolicy withDescription(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutablePolicy(this.id, newValue, this.name, this.rules, this.datacenters);
    }

    public final ImmutablePolicy withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutablePolicy(this.id, value, this.name, this.rules, this.datacenters);
    }

    public final ImmutablePolicy withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return new ImmutablePolicy(this.id, this.description, (String)Preconditions.checkNotNull((Object)value, (Object)"name"), this.rules, this.datacenters);
    }

    public final ImmutablePolicy withRules(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"rules");
        if (Objects.equals(this.rules, newValue)) {
            return this;
        }
        return new ImmutablePolicy(this.id, this.description, this.name, newValue, this.datacenters);
    }

    public final ImmutablePolicy withRules(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.rules, value)) {
            return this;
        }
        return new ImmutablePolicy(this.id, this.description, this.name, value, this.datacenters);
    }

    public final ImmutablePolicy withDatacenters(List<String> value) {
        List newValue = (List)Preconditions.checkNotNull(value, (Object)"datacenters");
        if (this.datacenters == newValue) {
            return this;
        }
        return new ImmutablePolicy(this.id, this.description, this.name, this.rules, newValue);
    }

    public final ImmutablePolicy withDatacenters(Optional<List<String>> optional) {
        List value = optional.orElse(null);
        if (this.datacenters == value) {
            return this;
        }
        return new ImmutablePolicy(this.id, this.description, this.name, this.rules, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePolicy && this.equalTo((ImmutablePolicy)another);
    }

    private boolean equalTo(ImmutablePolicy another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.description, another.description) && this.name.equals(another.name) && Objects.equals(this.rules, another.rules) && Objects.equals(this.datacenters, another.datacenters);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.id});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.description});
        h = h * 17 + this.name.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.rules});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.datacenters});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Policy").omitNullValues().add("id", (Object)this.id).add("description", (Object)this.description).add("name", (Object)this.name).add("rules", (Object)this.rules).add("datacenters", this.datacenters).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutablePolicy fromJson(Json json) {
        Builder builder = ImmutablePolicy.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.rules != null) {
            builder.rules(json.rules);
        }
        if (json.datacenters != null) {
            builder.datacenters(json.datacenters);
        }
        return builder.build();
    }

    public static ImmutablePolicy copyOf(Policy instance) {
        if (instance instanceof ImmutablePolicy) {
            return (ImmutablePolicy)instance;
        }
        return ImmutablePolicy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String description;
        @Nullable
        private String name;
        @Nullable
        private String rules;
        @Nullable
        private List<String> datacenters;

        private Builder() {
        }

        public final Builder from(Policy instance) {
            Optional<List<String>> datacentersOptional;
            Optional<String> descriptionOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> idOptional = instance.id();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            if ((descriptionOptional = instance.description()).isPresent()) {
                this.description(descriptionOptional);
            }
            this.name(instance.name());
            Optional<String> rulesOptional = instance.rules();
            if (rulesOptional.isPresent()) {
                this.rules(rulesOptional);
            }
            if ((datacentersOptional = instance.datacenters()).isPresent()) {
                this.datacenters(datacentersOptional);
            }
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            return this;
        }

        public final Builder id(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        public final Builder description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
            return this;
        }

        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder rules(String rules) {
            this.rules = (String)Preconditions.checkNotNull((Object)rules, (Object)"rules");
            return this;
        }

        public final Builder rules(Optional<String> rules) {
            this.rules = rules.orElse(null);
            return this;
        }

        public final Builder datacenters(List<String> datacenters) {
            this.datacenters = (List)Preconditions.checkNotNull(datacenters, (Object)"datacenters");
            return this;
        }

        public final Builder datacenters(Optional<List<String>> datacenters) {
            this.datacenters = datacenters.orElse(null);
            return this;
        }

        public ImmutablePolicy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePolicy(this.id, this.description, this.name, this.rules, this.datacenters);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Policy, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Policy {
        Optional<String> id = Optional.empty();
        Optional<String> description = Optional.empty();
        @Nullable
        String name;
        Optional<String> rules = Optional.empty();
        Optional<List<String>> datacenters = Optional.empty();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @JsonProperty(value="Description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Rules")
        public void setRules(Optional<String> rules) {
            this.rules = rules;
        }

        @JsonProperty(value="Datacenters")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public void setDatacenters(Optional<List<String>> datacenters) {
            this.datacenters = datacenters;
        }

        @Override
        public Optional<String> id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> rules() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> datacenters() {
            throw new UnsupportedOperationException();
        }
    }
}

