/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.catalog.ServiceWeights;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableServiceWeights
extends ServiceWeights {
    private final int passing;
    private final int warning;

    private ImmutableServiceWeights(int passing, int warning) {
        this.passing = passing;
        this.warning = warning;
    }

    @Override
    @JsonProperty(value="Passing")
    public int getPassing() {
        return this.passing;
    }

    @Override
    @JsonProperty(value="Warning")
    public int getWarning() {
        return this.warning;
    }

    public final ImmutableServiceWeights withPassing(int value) {
        if (this.passing == value) {
            return this;
        }
        return new ImmutableServiceWeights(value, this.warning);
    }

    public final ImmutableServiceWeights withWarning(int value) {
        if (this.warning == value) {
            return this;
        }
        return new ImmutableServiceWeights(this.passing, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceWeights && this.equalTo((ImmutableServiceWeights)another);
    }

    private boolean equalTo(ImmutableServiceWeights another) {
        return this.passing == another.passing && this.warning == another.warning;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.passing;
        h = h * 17 + this.warning;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServiceWeights").omitNullValues().add("passing", this.passing).add("warning", this.warning).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableServiceWeights fromJson(Json json) {
        Builder builder = ImmutableServiceWeights.builder();
        if (json.passing != null) {
            builder.passing(json.passing);
        }
        if (json.warning != null) {
            builder.warning(json.warning);
        }
        return builder.build();
    }

    public static ImmutableServiceWeights copyOf(ServiceWeights instance) {
        if (instance instanceof ImmutableServiceWeights) {
            return (ImmutableServiceWeights)instance;
        }
        return ImmutableServiceWeights.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PASSING = 1L;
        private static final long INIT_BIT_WARNING = 2L;
        private long initBits = 3L;
        private int passing;
        private int warning;

        private Builder() {
        }

        public final Builder from(ServiceWeights instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.passing(instance.getPassing());
            this.warning(instance.getWarning());
            return this;
        }

        public final Builder passing(int passing) {
            this.passing = passing;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder warning(int warning) {
            this.warning = warning;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableServiceWeights build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceWeights(this.passing, this.warning);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("passing");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("warning");
            }
            return "Cannot build ServiceWeights, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends ServiceWeights {
        @Nullable
        Integer passing;
        @Nullable
        Integer warning;

        Json() {
        }

        @JsonProperty(value="Passing")
        public void setPassing(int passing) {
            this.passing = passing;
        }

        @JsonProperty(value="Warning")
        public void setWarning(int warning) {
            this.warning = warning;
        }

        @Override
        public int getPassing() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getWarning() {
            throw new UnsupportedOperationException();
        }
    }
}

