/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.orbitz.consul.option.PutOptions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutablePutOptions
extends PutOptions {
    @Nullable
    private final Long cas;
    @Nullable
    private final String acquire;
    @Nullable
    private final String release;
    @Nullable
    private final String dc;
    @Nullable
    private final String token;

    private ImmutablePutOptions(@Nullable Long cas, @Nullable String acquire, @Nullable String release, @Nullable String dc, @Nullable String token) {
        this.cas = cas;
        this.acquire = acquire;
        this.release = release;
        this.dc = dc;
        this.token = token;
    }

    @Override
    public Optional<Long> getCas() {
        return Optional.ofNullable(this.cas);
    }

    @Override
    public Optional<String> getAcquire() {
        return Optional.ofNullable(this.acquire);
    }

    @Override
    public Optional<String> getRelease() {
        return Optional.ofNullable(this.release);
    }

    @Override
    public Optional<String> getDc() {
        return Optional.ofNullable(this.dc);
    }

    @Override
    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    public final ImmutablePutOptions withCas(long value) {
        Long newValue = value;
        if (Objects.equals(this.cas, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(newValue, this.acquire, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withCas(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.cas, value)) {
            return this;
        }
        return new ImmutablePutOptions(value, this.acquire, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withAcquire(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"acquire");
        if (Objects.equals(this.acquire, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, newValue, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withAcquire(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.acquire, value)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, value, this.release, this.dc, this.token);
    }

    public final ImmutablePutOptions withRelease(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"release");
        if (Objects.equals(this.release, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, this.acquire, newValue, this.dc, this.token);
    }

    public final ImmutablePutOptions withRelease(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.release, value)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, this.acquire, value, this.dc, this.token);
    }

    public final ImmutablePutOptions withDc(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"dc");
        if (Objects.equals(this.dc, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, this.acquire, this.release, newValue, this.token);
    }

    public final ImmutablePutOptions withDc(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.dc, value)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, this.acquire, this.release, value, this.token);
    }

    public final ImmutablePutOptions withToken(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"token");
        if (Objects.equals(this.token, newValue)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, this.acquire, this.release, this.dc, newValue);
    }

    public final ImmutablePutOptions withToken(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutablePutOptions(this.cas, this.acquire, this.release, this.dc, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePutOptions && this.equalTo((ImmutablePutOptions)another);
    }

    private boolean equalTo(ImmutablePutOptions another) {
        return Objects.equals(this.cas, another.cas) && Objects.equals(this.acquire, another.acquire) && Objects.equals(this.release, another.release) && Objects.equals(this.dc, another.dc) && Objects.equals(this.token, another.token);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.cas});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.acquire});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.release});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.dc});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.token});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PutOptions").omitNullValues().add("cas", (Object)this.cas).add("acquire", (Object)this.acquire).add("release", (Object)this.release).add("dc", (Object)this.dc).add("token", (Object)this.token).toString();
    }

    public static ImmutablePutOptions copyOf(PutOptions instance) {
        if (instance instanceof ImmutablePutOptions) {
            return (ImmutablePutOptions)instance;
        }
        return ImmutablePutOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Long cas;
        @Nullable
        private String acquire;
        @Nullable
        private String release;
        @Nullable
        private String dc;
        @Nullable
        private String token;

        private Builder() {
        }

        public final Builder from(PutOptions instance) {
            Optional<String> tokenOptional;
            Optional<String> dcOptional;
            Optional<String> releaseOptional;
            Optional<String> acquireOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<Long> casOptional = instance.getCas();
            if (casOptional.isPresent()) {
                this.cas(casOptional);
            }
            if ((acquireOptional = instance.getAcquire()).isPresent()) {
                this.acquire(acquireOptional);
            }
            if ((releaseOptional = instance.getRelease()).isPresent()) {
                this.release(releaseOptional);
            }
            if ((dcOptional = instance.getDc()).isPresent()) {
                this.dc(dcOptional);
            }
            if ((tokenOptional = instance.getToken()).isPresent()) {
                this.token(tokenOptional);
            }
            return this;
        }

        public final Builder cas(long cas) {
            this.cas = cas;
            return this;
        }

        public final Builder cas(Optional<Long> cas) {
            this.cas = cas.orElse(null);
            return this;
        }

        public final Builder acquire(String acquire) {
            this.acquire = (String)Preconditions.checkNotNull((Object)acquire, (Object)"acquire");
            return this;
        }

        public final Builder acquire(Optional<String> acquire) {
            this.acquire = acquire.orElse(null);
            return this;
        }

        public final Builder release(String release) {
            this.release = (String)Preconditions.checkNotNull((Object)release, (Object)"release");
            return this;
        }

        public final Builder release(Optional<String> release) {
            this.release = release.orElse(null);
            return this;
        }

        public final Builder dc(String dc) {
            this.dc = (String)Preconditions.checkNotNull((Object)dc, (Object)"dc");
            return this;
        }

        public final Builder dc(Optional<String> dc) {
            this.dc = dc.orElse(null);
            return this;
        }

        public final Builder token(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
            return this;
        }

        public final Builder token(Optional<String> token) {
            this.token = token.orElse(null);
            return this;
        }

        public ImmutablePutOptions build() {
            return new ImmutablePutOptions(this.cas, this.acquire, this.release, this.dc, this.token);
        }
    }
}

