/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.kv;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orbitz.consul.model.kv.TxError;
import com.orbitz.consul.model.kv.TxResponse;
import com.orbitz.consul.model.kv.Value;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableTxResponse
extends TxResponse {
    private final ImmutableList<Map<String, Value>> results;
    private final ImmutableList<TxError> errors;

    private ImmutableTxResponse(ImmutableList<Map<String, Value>> results, ImmutableList<TxError> errors) {
        this.results = results;
        this.errors = errors;
    }

    @JsonProperty(value="Results")
    public ImmutableList<Map<String, Value>> results() {
        return this.results;
    }

    @JsonProperty(value="Errors")
    public ImmutableList<TxError> errors() {
        return this.errors;
    }

    @SafeVarargs
    public final ImmutableTxResponse withResults(Map<String, Value> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTxResponse((ImmutableList<Map<String, Value>>)newValue, this.errors);
    }

    public final ImmutableTxResponse withResults(Iterable<? extends Map<String, Value>> elements) {
        if (this.results == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTxResponse((ImmutableList<Map<String, Value>>)newValue, this.errors);
    }

    public final ImmutableTxResponse withErrors(TxError ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTxResponse(this.results, (ImmutableList<TxError>)newValue);
    }

    public final ImmutableTxResponse withErrors(Iterable<? extends TxError> elements) {
        if (this.errors == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTxResponse(this.results, (ImmutableList<TxError>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTxResponse && this.equalTo((ImmutableTxResponse)another);
    }

    private boolean equalTo(ImmutableTxResponse another) {
        return this.results.equals(another.results) && this.errors.equals(another.errors);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.results.hashCode();
        h = h * 17 + this.errors.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TxResponse").omitNullValues().add("results", this.results).add("errors", this.errors).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableTxResponse fromJson(Json json) {
        Builder builder = ImmutableTxResponse.builder();
        if (json.results != null) {
            builder.addAllResults(json.results);
        }
        if (json.errors != null) {
            builder.addAllErrors(json.errors);
        }
        return builder.build();
    }

    public static ImmutableTxResponse copyOf(TxResponse instance) {
        if (instance instanceof ImmutableTxResponse) {
            return (ImmutableTxResponse)instance;
        }
        return ImmutableTxResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<Map<String, Value>> resultsBuilder = ImmutableList.builder();
        private ImmutableList.Builder<TxError> errorsBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(TxResponse instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllResults(instance.results());
            this.addAllErrors(instance.errors());
            return this;
        }

        public final Builder addResults(Map<String, Value> element) {
            this.resultsBuilder.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder addResults(Map<String, Value> ... elements) {
            this.resultsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder results(Iterable<? extends Map<String, Value>> elements) {
            this.resultsBuilder = ImmutableList.builder();
            return this.addAllResults(elements);
        }

        public final Builder addAllResults(Iterable<? extends Map<String, Value>> elements) {
            this.resultsBuilder.addAll(elements);
            return this;
        }

        public final Builder addErrors(TxError element) {
            this.errorsBuilder.add((Object)element);
            return this;
        }

        public final Builder addErrors(TxError ... elements) {
            this.errorsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder errors(Iterable<? extends TxError> elements) {
            this.errorsBuilder = ImmutableList.builder();
            return this.addAllErrors(elements);
        }

        public final Builder addAllErrors(Iterable<? extends TxError> elements) {
            this.errorsBuilder.addAll(elements);
            return this;
        }

        public ImmutableTxResponse build() {
            return new ImmutableTxResponse(this.resultsBuilder.build(), this.errorsBuilder.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends TxResponse {
        List<Map<String, Value>> results = ImmutableList.of();
        List<TxError> errors = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="Results")
        public void setResults(List<Map<String, Value>> results) {
            this.results = results;
        }

        @JsonProperty(value="Errors")
        public void setErrors(List<TxError> errors) {
            this.errors = errors;
        }

        @Override
        public List<Map<String, Value>> results() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<TxError> errors() {
            throw new UnsupportedOperationException();
        }
    }
}

