/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.orbitz.consul.option.ConsistencyMode;
import com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableQueryOptions
extends QueryOptions {
    @Nullable
    private final String wait;
    @Nullable
    private final String token;
    @Nullable
    private final BigInteger index;
    @Nullable
    private final String near;
    @Nullable
    private final String datacenter;
    private final ImmutableList<String> nodeMeta;
    private final ImmutableList<String> tag;
    private final ConsistencyMode consistencyMode;
    private final boolean isBlocking;
    private final boolean hasToken;
    private final List<String> nodeMetaQuery;
    private final List<String> tagsQuery;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableQueryOptions(Builder builder) {
        this.wait = builder.wait;
        this.token = builder.token;
        this.index = builder.index;
        this.near = builder.near;
        this.datacenter = builder.datacenter;
        this.nodeMeta = builder.nodeMetaBuilder.build();
        this.tag = builder.tagBuilder.build();
        if (builder.consistencyMode != null) {
            this.initShim.consistencyMode(builder.consistencyMode);
        }
        this.consistencyMode = this.initShim.getConsistencyMode();
        this.isBlocking = this.initShim.isBlocking();
        this.hasToken = this.initShim.hasToken();
        this.nodeMetaQuery = this.initShim.getNodeMetaQuery();
        this.tagsQuery = this.initShim.getTagsQuery();
        this.initShim = null;
    }

    private ImmutableQueryOptions(@Nullable String wait, @Nullable String token, @Nullable BigInteger index, @Nullable String near, @Nullable String datacenter, ImmutableList<String> nodeMeta, ImmutableList<String> tag, ConsistencyMode consistencyMode) {
        this.wait = wait;
        this.token = token;
        this.index = index;
        this.near = near;
        this.datacenter = datacenter;
        this.nodeMeta = nodeMeta;
        this.tag = tag;
        this.consistencyMode = consistencyMode;
        this.initShim.consistencyMode(consistencyMode);
        this.isBlocking = this.initShim.isBlocking();
        this.hasToken = this.initShim.hasToken();
        this.nodeMetaQuery = this.initShim.getNodeMetaQuery();
        this.tagsQuery = this.initShim.getTagsQuery();
        this.initShim = null;
    }

    @Override
    public Optional<String> getWait() {
        return Optional.ofNullable(this.wait);
    }

    @Override
    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    @Override
    public Optional<BigInteger> getIndex() {
        return Optional.ofNullable(this.index);
    }

    @Override
    public Optional<String> getNear() {
        return Optional.ofNullable(this.near);
    }

    @Override
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    public ImmutableList<String> getNodeMeta() {
        return this.nodeMeta;
    }

    public ImmutableList<String> getTag() {
        return this.tag;
    }

    @Override
    public ConsistencyMode getConsistencyMode() {
        return this.initShim != null ? this.initShim.getConsistencyMode() : this.consistencyMode;
    }

    @Override
    public boolean isBlocking() {
        return this.initShim != null ? this.initShim.isBlocking() : this.isBlocking;
    }

    @Override
    public boolean hasToken() {
        return this.initShim != null ? this.initShim.hasToken() : this.hasToken;
    }

    @Override
    public List<String> getNodeMetaQuery() {
        return this.initShim != null ? this.initShim.getNodeMetaQuery() : this.nodeMetaQuery;
    }

    @Override
    public List<String> getTagsQuery() {
        return this.initShim != null ? this.initShim.getTagsQuery() : this.tagsQuery;
    }

    public final ImmutableQueryOptions withWait(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"wait");
        if (Objects.equals(this.wait, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(newValue, this.token, this.index, this.near, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withWait(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.wait, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(value, this.token, this.index, this.near, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withToken(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"token");
        if (Objects.equals(this.token, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, newValue, this.index, this.near, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withToken(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, value, this.index, this.near, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withIndex(BigInteger value) {
        BigInteger newValue = (BigInteger)Preconditions.checkNotNull((Object)value, (Object)"index");
        if (this.index == newValue) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, newValue, this.near, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withIndex(Optional<BigInteger> optional) {
        BigInteger value = optional.orElse(null);
        if (this.index == value) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, value, this.near, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNear(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"near");
        if (Objects.equals(this.near, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, newValue, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNear(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.near, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, value, this.datacenter, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withDatacenter(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, this.near, newValue, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, this.near, value, this.nodeMeta, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNodeMeta(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, this.near, this.datacenter, (ImmutableList<String>)newValue, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withNodeMeta(Iterable<String> elements) {
        if (this.nodeMeta == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, this.near, this.datacenter, (ImmutableList<String>)newValue, this.tag, this.consistencyMode));
    }

    public final ImmutableQueryOptions withTag(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, this.near, this.datacenter, this.nodeMeta, (ImmutableList<String>)newValue, this.consistencyMode));
    }

    public final ImmutableQueryOptions withTag(Iterable<String> elements) {
        if (this.tag == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, this.near, this.datacenter, this.nodeMeta, (ImmutableList<String>)newValue, this.consistencyMode));
    }

    public final ImmutableQueryOptions withConsistencyMode(ConsistencyMode value) {
        if (this.consistencyMode == value) {
            return this;
        }
        return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this.wait, this.token, this.index, this.near, this.datacenter, this.nodeMeta, this.tag, (ConsistencyMode)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"consistencyMode"))));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryOptions && this.equalTo((ImmutableQueryOptions)another);
    }

    private boolean equalTo(ImmutableQueryOptions another) {
        return Objects.equals(this.wait, another.wait) && Objects.equals(this.token, another.token) && Objects.equals(this.index, another.index) && Objects.equals(this.near, another.near) && Objects.equals(this.datacenter, another.datacenter) && this.nodeMeta.equals(another.nodeMeta) && this.tag.equals(another.tag) && this.consistencyMode.equals((Object)another.consistencyMode) && this.isBlocking == another.isBlocking && this.hasToken == another.hasToken && this.nodeMetaQuery.equals(another.nodeMetaQuery) && this.tagsQuery.equals(another.tagsQuery);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.wait});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.token});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.index});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.near});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.datacenter});
        h = h * 17 + this.nodeMeta.hashCode();
        h = h * 17 + this.tag.hashCode();
        h = h * 17 + this.consistencyMode.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.isBlocking);
        h = h * 17 + Booleans.hashCode((boolean)this.hasToken);
        h = h * 17 + this.nodeMetaQuery.hashCode();
        h = h * 17 + this.tagsQuery.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"QueryOptions").omitNullValues().add("wait", (Object)this.wait).add("token", (Object)this.token).add("index", (Object)this.index).add("near", (Object)this.near).add("datacenter", (Object)this.datacenter).add("nodeMeta", this.nodeMeta).add("tag", this.tag).add("consistencyMode", (Object)this.consistencyMode).add("isBlocking", this.isBlocking).add("hasToken", this.hasToken).add("nodeMetaQuery", this.nodeMetaQuery).add("tagsQuery", this.tagsQuery).toString();
    }

    private static ImmutableQueryOptions validate(ImmutableQueryOptions instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableQueryOptions copyOf(QueryOptions instance) {
        if (instance instanceof ImmutableQueryOptions) {
            return (ImmutableQueryOptions)instance;
        }
        return ImmutableQueryOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String wait;
        @Nullable
        private String token;
        @Nullable
        private BigInteger index;
        @Nullable
        private String near;
        @Nullable
        private String datacenter;
        private ImmutableList.Builder<String> nodeMetaBuilder = ImmutableList.builder();
        private ImmutableList.Builder<String> tagBuilder = ImmutableList.builder();
        @Nullable
        private ConsistencyMode consistencyMode;

        private Builder() {
        }

        public final Builder from(QueryOptions instance) {
            Optional<String> datacenterOptional;
            Optional<String> nearOptional;
            Optional<BigInteger> indexOptional;
            Optional<String> tokenOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> waitOptional = instance.getWait();
            if (waitOptional.isPresent()) {
                this.wait(waitOptional);
            }
            if ((tokenOptional = instance.getToken()).isPresent()) {
                this.token(tokenOptional);
            }
            if ((indexOptional = instance.getIndex()).isPresent()) {
                this.index(indexOptional);
            }
            if ((nearOptional = instance.getNear()).isPresent()) {
                this.near(nearOptional);
            }
            if ((datacenterOptional = instance.getDatacenter()).isPresent()) {
                this.datacenter(datacenterOptional);
            }
            this.addAllNodeMeta(instance.getNodeMeta());
            this.addAllTag(instance.getTag());
            this.consistencyMode(instance.getConsistencyMode());
            return this;
        }

        public final Builder wait(String wait) {
            this.wait = (String)Preconditions.checkNotNull((Object)wait, (Object)"wait");
            return this;
        }

        public final Builder wait(Optional<String> wait) {
            this.wait = wait.orElse(null);
            return this;
        }

        public final Builder token(String token) {
            this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
            return this;
        }

        public final Builder token(Optional<String> token) {
            this.token = token.orElse(null);
            return this;
        }

        public final Builder index(BigInteger index) {
            this.index = (BigInteger)Preconditions.checkNotNull((Object)index, (Object)"index");
            return this;
        }

        public final Builder index(Optional<BigInteger> index) {
            this.index = index.orElse(null);
            return this;
        }

        public final Builder near(String near) {
            this.near = (String)Preconditions.checkNotNull((Object)near, (Object)"near");
            return this;
        }

        public final Builder near(Optional<String> near) {
            this.near = near.orElse(null);
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = (String)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        public final Builder addNodeMeta(String element) {
            this.nodeMetaBuilder.add((Object)element);
            return this;
        }

        public final Builder addNodeMeta(String ... elements) {
            this.nodeMetaBuilder.add((Object[])elements);
            return this;
        }

        public final Builder nodeMeta(Iterable<String> elements) {
            this.nodeMetaBuilder = ImmutableList.builder();
            return this.addAllNodeMeta(elements);
        }

        public final Builder addAllNodeMeta(Iterable<String> elements) {
            this.nodeMetaBuilder.addAll(elements);
            return this;
        }

        public final Builder addTag(String element) {
            this.tagBuilder.add((Object)element);
            return this;
        }

        public final Builder addTag(String ... elements) {
            this.tagBuilder.add((Object[])elements);
            return this;
        }

        public final Builder tag(Iterable<String> elements) {
            this.tagBuilder = ImmutableList.builder();
            return this.addAllTag(elements);
        }

        public final Builder addAllTag(Iterable<String> elements) {
            this.tagBuilder.addAll(elements);
            return this;
        }

        public final Builder consistencyMode(ConsistencyMode consistencyMode) {
            this.consistencyMode = (ConsistencyMode)((Object)Preconditions.checkNotNull((Object)((Object)consistencyMode), (Object)"consistencyMode"));
            return this;
        }

        public ImmutableQueryOptions build() {
            return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this));
        }
    }

    private final class InitShim {
        private ConsistencyMode consistencyMode;
        private byte consistencyModeStage;
        private boolean isBlocking;
        private byte isBlockingStage;
        private boolean hasToken;
        private byte hasTokenStage;
        private List<String> nodeMetaQuery;
        private byte nodeMetaQueryStage;
        private List<String> tagsQuery;
        private byte tagsQueryStage;

        private InitShim() {
        }

        ConsistencyMode getConsistencyMode() {
            if (this.consistencyModeStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.consistencyModeStage == 0) {
                this.consistencyModeStage = (byte)-1;
                this.consistencyMode = (ConsistencyMode)((Object)Preconditions.checkNotNull((Object)((Object)ImmutableQueryOptions.super.getConsistencyMode()), (Object)"consistencyMode"));
                this.consistencyModeStage = 1;
            }
            return this.consistencyMode;
        }

        ConsistencyMode consistencyMode(ConsistencyMode value) {
            this.consistencyMode = value;
            this.consistencyModeStage = 1;
            return value;
        }

        boolean isBlocking() {
            if (this.isBlockingStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isBlockingStage == 0) {
                this.isBlockingStage = (byte)-1;
                this.isBlocking = ImmutableQueryOptions.super.isBlocking();
                this.isBlockingStage = 1;
            }
            return this.isBlocking;
        }

        boolean hasToken() {
            if (this.hasTokenStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasTokenStage == 0) {
                this.hasTokenStage = (byte)-1;
                this.hasToken = ImmutableQueryOptions.super.hasToken();
                this.hasTokenStage = 1;
            }
            return this.hasToken;
        }

        List<String> getNodeMetaQuery() {
            if (this.nodeMetaQueryStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeMetaQueryStage == 0) {
                this.nodeMetaQueryStage = (byte)-1;
                this.nodeMetaQuery = (List)Preconditions.checkNotNull((Object)ImmutableQueryOptions.super.getNodeMetaQuery(), (Object)"nodeMetaQuery");
                this.nodeMetaQueryStage = 1;
            }
            return this.nodeMetaQuery;
        }

        List<String> getTagsQuery() {
            if (this.tagsQueryStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tagsQueryStage == 0) {
                this.tagsQueryStage = (byte)-1;
                this.tagsQuery = (List)Preconditions.checkNotNull((Object)ImmutableQueryOptions.super.getTagsQuery(), (Object)"tagsQuery");
                this.tagsQueryStage = 1;
            }
            return this.tagsQuery;
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = Lists.newArrayList();
            if (this.consistencyModeStage == -1) {
                attributes.add("consistencyMode");
            }
            if (this.isBlockingStage == -1) {
                attributes.add("isBlocking");
            }
            if (this.hasTokenStage == -1) {
                attributes.add("hasToken");
            }
            if (this.nodeMetaQueryStage == -1) {
                attributes.add("nodeMetaQuery");
            }
            if (this.tagsQueryStage == -1) {
                attributes.add("tagsQuery");
            }
            return "Cannot build QueryOptions, attribute initializers form cycle" + attributes;
        }
    }
}

