/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.catalog.CatalogDeregistration;
import com.orbitz.consul.model.catalog.WriteRequest;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableCatalogDeregistration
extends CatalogDeregistration {
    @Nullable
    private final String datacenter;
    private final String node;
    @Nullable
    private final String checkId;
    @Nullable
    private final String serviceId;
    @Nullable
    private final WriteRequest writeRequest;

    private ImmutableCatalogDeregistration(@Nullable String datacenter, String node, @Nullable String checkId, @Nullable String serviceId, @Nullable WriteRequest writeRequest) {
        this.datacenter = datacenter;
        this.node = node;
        this.checkId = checkId;
        this.serviceId = serviceId;
        this.writeRequest = writeRequest;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public Optional<String> datacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    @JsonProperty(value="Node")
    public String node() {
        return this.node;
    }

    @Override
    @JsonProperty(value="CheckID")
    public Optional<String> checkId() {
        return Optional.ofNullable(this.checkId);
    }

    @Override
    @JsonProperty(value="ServiceID")
    public Optional<String> serviceId() {
        return Optional.ofNullable(this.serviceId);
    }

    @Override
    @JsonProperty(value="WriteRequest")
    public Optional<WriteRequest> writeRequest() {
        return Optional.ofNullable(this.writeRequest);
    }

    public final ImmutableCatalogDeregistration withDatacenter(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableCatalogDeregistration(newValue, this.node, this.checkId, this.serviceId, this.writeRequest);
    }

    public final ImmutableCatalogDeregistration withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableCatalogDeregistration(value, this.node, this.checkId, this.serviceId, this.writeRequest);
    }

    public final ImmutableCatalogDeregistration withNode(String value) {
        if (this.node.equals(value)) {
            return this;
        }
        return new ImmutableCatalogDeregistration(this.datacenter, (String)Preconditions.checkNotNull((Object)value, (Object)"node"), this.checkId, this.serviceId, this.writeRequest);
    }

    public final ImmutableCatalogDeregistration withCheckId(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"checkId");
        if (Objects.equals(this.checkId, newValue)) {
            return this;
        }
        return new ImmutableCatalogDeregistration(this.datacenter, this.node, newValue, this.serviceId, this.writeRequest);
    }

    public final ImmutableCatalogDeregistration withCheckId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.checkId, value)) {
            return this;
        }
        return new ImmutableCatalogDeregistration(this.datacenter, this.node, value, this.serviceId, this.writeRequest);
    }

    public final ImmutableCatalogDeregistration withServiceId(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"serviceId");
        if (Objects.equals(this.serviceId, newValue)) {
            return this;
        }
        return new ImmutableCatalogDeregistration(this.datacenter, this.node, this.checkId, newValue, this.writeRequest);
    }

    public final ImmutableCatalogDeregistration withServiceId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.serviceId, value)) {
            return this;
        }
        return new ImmutableCatalogDeregistration(this.datacenter, this.node, this.checkId, value, this.writeRequest);
    }

    public final ImmutableCatalogDeregistration withWriteRequest(WriteRequest value) {
        WriteRequest newValue = (WriteRequest)Preconditions.checkNotNull((Object)value, (Object)"writeRequest");
        if (this.writeRequest == newValue) {
            return this;
        }
        return new ImmutableCatalogDeregistration(this.datacenter, this.node, this.checkId, this.serviceId, newValue);
    }

    public final ImmutableCatalogDeregistration withWriteRequest(Optional<WriteRequest> optional) {
        WriteRequest value = optional.orElse(null);
        if (this.writeRequest == value) {
            return this;
        }
        return new ImmutableCatalogDeregistration(this.datacenter, this.node, this.checkId, this.serviceId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogDeregistration && this.equalTo((ImmutableCatalogDeregistration)another);
    }

    private boolean equalTo(ImmutableCatalogDeregistration another) {
        return Objects.equals(this.datacenter, another.datacenter) && this.node.equals(another.node) && Objects.equals(this.checkId, another.checkId) && Objects.equals(this.serviceId, another.serviceId) && Objects.equals(this.writeRequest, another.writeRequest);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.datacenter});
        h = h * 17 + this.node.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.checkId});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.serviceId});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.writeRequest});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CatalogDeregistration").omitNullValues().add("datacenter", (Object)this.datacenter).add("node", (Object)this.node).add("checkId", (Object)this.checkId).add("serviceId", (Object)this.serviceId).add("writeRequest", (Object)this.writeRequest).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableCatalogDeregistration fromJson(Json json) {
        Builder builder = ImmutableCatalogDeregistration.builder();
        if (json.datacenter != null) {
            builder.datacenter(json.datacenter);
        }
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.checkId != null) {
            builder.checkId(json.checkId);
        }
        if (json.serviceId != null) {
            builder.serviceId(json.serviceId);
        }
        if (json.writeRequest != null) {
            builder.writeRequest(json.writeRequest);
        }
        return builder.build();
    }

    public static ImmutableCatalogDeregistration copyOf(CatalogDeregistration instance) {
        if (instance instanceof ImmutableCatalogDeregistration) {
            return (ImmutableCatalogDeregistration)instance;
        }
        return ImmutableCatalogDeregistration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private long initBits = 1L;
        @Nullable
        private String datacenter;
        @Nullable
        private String node;
        @Nullable
        private String checkId;
        @Nullable
        private String serviceId;
        @Nullable
        private WriteRequest writeRequest;

        private Builder() {
        }

        public final Builder from(CatalogDeregistration instance) {
            Optional<WriteRequest> writeRequestOptional;
            Optional<String> serviceIdOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> datacenterOptional = instance.datacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            this.node(instance.node());
            Optional<String> checkIdOptional = instance.checkId();
            if (checkIdOptional.isPresent()) {
                this.checkId(checkIdOptional);
            }
            if ((serviceIdOptional = instance.serviceId()).isPresent()) {
                this.serviceId(serviceIdOptional);
            }
            if ((writeRequestOptional = instance.writeRequest()).isPresent()) {
                this.writeRequest(writeRequestOptional);
            }
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = (String)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        public final Builder node(String node) {
            this.node = (String)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder checkId(String checkId) {
            this.checkId = (String)Preconditions.checkNotNull((Object)checkId, (Object)"checkId");
            return this;
        }

        public final Builder checkId(Optional<String> checkId) {
            this.checkId = checkId.orElse(null);
            return this;
        }

        public final Builder serviceId(String serviceId) {
            this.serviceId = (String)Preconditions.checkNotNull((Object)serviceId, (Object)"serviceId");
            return this;
        }

        public final Builder serviceId(Optional<String> serviceId) {
            this.serviceId = serviceId.orElse(null);
            return this;
        }

        public final Builder writeRequest(WriteRequest writeRequest) {
            this.writeRequest = (WriteRequest)Preconditions.checkNotNull((Object)writeRequest, (Object)"writeRequest");
            return this;
        }

        public final Builder writeRequest(Optional<WriteRequest> writeRequest) {
            this.writeRequest = writeRequest.orElse(null);
            return this;
        }

        public ImmutableCatalogDeregistration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCatalogDeregistration(this.datacenter, this.node, this.checkId, this.serviceId, this.writeRequest);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            return "Cannot build CatalogDeregistration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends CatalogDeregistration {
        Optional<String> datacenter = Optional.empty();
        @Nullable
        String node;
        Optional<String> checkId = Optional.empty();
        Optional<String> serviceId = Optional.empty();
        Optional<WriteRequest> writeRequest = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(Optional<String> datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="CheckID")
        public void setCheckId(Optional<String> checkId) {
            this.checkId = checkId;
        }

        @JsonProperty(value="ServiceID")
        public void setServiceId(Optional<String> serviceId) {
            this.serviceId = serviceId;
        }

        @JsonProperty(value="WriteRequest")
        public void setWriteRequest(Optional<WriteRequest> writeRequest) {
            this.writeRequest = writeRequest;
        }

        @Override
        public Optional<String> datacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String node() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> checkId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> serviceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<WriteRequest> writeRequest() {
            throw new UnsupportedOperationException();
        }
    }
}

