/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.catalog.CatalogService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableCatalogService
extends CatalogService {
    private final String node;
    private final String address;
    @Nullable
    private final String datacenter;
    private final String serviceName;
    private final String serviceId;
    private final String serviceAddress;
    @Nullable
    private final Boolean serviceEnableTagOverride;
    private final int servicePort;
    private final ImmutableList<String> serviceTags;
    @Nullable
    private final Map<String, String> serviceMeta;
    @Nullable
    private final Map<String, String> nodeMeta;

    private ImmutableCatalogService(String node, String address, @Nullable String datacenter, String serviceName, String serviceId, String serviceAddress, @Nullable Boolean serviceEnableTagOverride, int servicePort, ImmutableList<String> serviceTags, @Nullable Map<String, String> serviceMeta, @Nullable Map<String, String> nodeMeta) {
        this.node = node;
        this.address = address;
        this.datacenter = datacenter;
        this.serviceName = serviceName;
        this.serviceId = serviceId;
        this.serviceAddress = serviceAddress;
        this.serviceEnableTagOverride = serviceEnableTagOverride;
        this.servicePort = servicePort;
        this.serviceTags = serviceTags;
        this.serviceMeta = serviceMeta;
        this.nodeMeta = nodeMeta;
    }

    @Override
    @JsonProperty(value="Node")
    public String getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Address")
    public String getAddress() {
        return this.address;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    @JsonProperty(value="ServiceName")
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    @JsonProperty(value="ServiceID")
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    @JsonProperty(value="ServiceAddress")
    public String getServiceAddress() {
        return this.serviceAddress;
    }

    @Override
    @JsonProperty(value="ServiceEnableTagOverride")
    public Optional<Boolean> getServiceEnableTagOverride() {
        return Optional.ofNullable(this.serviceEnableTagOverride);
    }

    @Override
    @JsonProperty(value="ServicePort")
    public int getServicePort() {
        return this.servicePort;
    }

    @JsonProperty(value="ServiceTags")
    public ImmutableList<String> getServiceTags() {
        return this.serviceTags;
    }

    @Override
    @JsonProperty(value="ServiceMeta")
    public Optional<Map<String, String>> getServiceMeta() {
        return Optional.ofNullable(this.serviceMeta);
    }

    @Override
    @JsonProperty(value="NodeMeta")
    public Optional<Map<String, String>> getNodeMeta() {
        return Optional.ofNullable(this.nodeMeta);
    }

    public final ImmutableCatalogService withNode(String value) {
        if (this.node.equals(value)) {
            return this;
        }
        return new ImmutableCatalogService((String)Preconditions.checkNotNull((Object)value, (Object)"node"), this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.nodeMeta);
    }

    public final ImmutableCatalogService withAddress(String value) {
        if (this.address.equals(value)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, (String)Preconditions.checkNotNull((Object)value, (Object)"address"), this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.nodeMeta);
    }

    public final ImmutableCatalogService withDatacenter(String value) {
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, newValue, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.nodeMeta);
    }

    public final ImmutableCatalogService withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, value, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceName(String value) {
        if (this.serviceName.equals(value)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, (String)Preconditions.checkNotNull((Object)value, (Object)"serviceName"), this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceId(String value) {
        if (this.serviceId.equals(value)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, (String)Preconditions.checkNotNull((Object)value, (Object)"serviceId"), this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceAddress(String value) {
        if (this.serviceAddress.equals(value)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, (String)Preconditions.checkNotNull((Object)value, (Object)"serviceAddress"), this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceEnableTagOverride(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.serviceEnableTagOverride, newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, newValue, this.servicePort, this.serviceTags, this.serviceMeta, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceEnableTagOverride(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.serviceEnableTagOverride, value)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, value, this.servicePort, this.serviceTags, this.serviceMeta, this.nodeMeta);
    }

    public final ImmutableCatalogService withServicePort(int value) {
        if (this.servicePort == value) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, value, this.serviceTags, this.serviceMeta, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, (ImmutableList<String>)newValue, this.serviceMeta, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceTags(Iterable<String> elements) {
        if (this.serviceTags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, (ImmutableList<String>)newValue, this.serviceMeta, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceMeta(Map<String, String> value) {
        Map newValue = (Map)Preconditions.checkNotNull(value, (Object)"serviceMeta");
        if (this.serviceMeta == newValue) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, newValue, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceMeta(Optional<Map<String, String>> optional) {
        Map value = optional.orElse(null);
        if (this.serviceMeta == value) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, value, this.nodeMeta);
    }

    public final ImmutableCatalogService withNodeMeta(Map<String, String> value) {
        Map newValue = (Map)Preconditions.checkNotNull(value, (Object)"nodeMeta");
        if (this.nodeMeta == newValue) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, newValue);
    }

    public final ImmutableCatalogService withNodeMeta(Optional<Map<String, String>> optional) {
        Map value = optional.orElse(null);
        if (this.nodeMeta == value) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTags, this.serviceMeta, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogService && this.equalTo((ImmutableCatalogService)another);
    }

    private boolean equalTo(ImmutableCatalogService another) {
        return this.node.equals(another.node) && this.address.equals(another.address) && Objects.equals(this.datacenter, another.datacenter) && this.serviceName.equals(another.serviceName) && this.serviceId.equals(another.serviceId) && this.serviceAddress.equals(another.serviceAddress) && Objects.equals(this.serviceEnableTagOverride, another.serviceEnableTagOverride) && this.servicePort == another.servicePort && this.serviceTags.equals(another.serviceTags) && Objects.equals(this.serviceMeta, another.serviceMeta) && Objects.equals(this.nodeMeta, another.nodeMeta);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.address.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.datacenter});
        h = h * 17 + this.serviceName.hashCode();
        h = h * 17 + this.serviceId.hashCode();
        h = h * 17 + this.serviceAddress.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.serviceEnableTagOverride});
        h = h * 17 + this.servicePort;
        h = h * 17 + this.serviceTags.hashCode();
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.serviceMeta});
        h = h * 17 + com.google.common.base.Objects.hashCode((Object[])new Object[]{this.nodeMeta});
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CatalogService").omitNullValues().add("node", (Object)this.node).add("address", (Object)this.address).add("datacenter", (Object)this.datacenter).add("serviceName", (Object)this.serviceName).add("serviceId", (Object)this.serviceId).add("serviceAddress", (Object)this.serviceAddress).add("serviceEnableTagOverride", (Object)this.serviceEnableTagOverride).add("servicePort", this.servicePort).add("serviceTags", this.serviceTags).add("serviceMeta", this.serviceMeta).add("nodeMeta", this.nodeMeta).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableCatalogService fromJson(Json json) {
        Builder builder = ImmutableCatalogService.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.datacenter != null) {
            builder.datacenter(json.datacenter);
        }
        if (json.serviceName != null) {
            builder.serviceName(json.serviceName);
        }
        if (json.serviceId != null) {
            builder.serviceId(json.serviceId);
        }
        if (json.serviceAddress != null) {
            builder.serviceAddress(json.serviceAddress);
        }
        if (json.serviceEnableTagOverride != null) {
            builder.serviceEnableTagOverride(json.serviceEnableTagOverride);
        }
        if (json.servicePort != null) {
            builder.servicePort(json.servicePort);
        }
        if (json.serviceTags != null) {
            builder.addAllServiceTags(json.serviceTags);
        }
        if (json.serviceMeta != null) {
            builder.serviceMeta(json.serviceMeta);
        }
        if (json.nodeMeta != null) {
            builder.nodeMeta(json.nodeMeta);
        }
        return builder.build();
    }

    public static ImmutableCatalogService copyOf(CatalogService instance) {
        if (instance instanceof ImmutableCatalogService) {
            return (ImmutableCatalogService)instance;
        }
        return ImmutableCatalogService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_ADDRESS = 2L;
        private static final long INIT_BIT_SERVICE_NAME = 4L;
        private static final long INIT_BIT_SERVICE_ID = 8L;
        private static final long INIT_BIT_SERVICE_ADDRESS = 16L;
        private static final long INIT_BIT_SERVICE_PORT = 32L;
        private long initBits = 63L;
        @Nullable
        private String node;
        @Nullable
        private String address;
        @Nullable
        private String datacenter;
        @Nullable
        private String serviceName;
        @Nullable
        private String serviceId;
        @Nullable
        private String serviceAddress;
        @Nullable
        private Boolean serviceEnableTagOverride;
        private int servicePort;
        private ImmutableList.Builder<String> serviceTagsBuilder = ImmutableList.builder();
        @Nullable
        private Map<String, String> serviceMeta;
        @Nullable
        private Map<String, String> nodeMeta;

        private Builder() {
        }

        public final Builder from(CatalogService instance) {
            Optional<Map<String, String>> nodeMetaOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.node(instance.getNode());
            this.address(instance.getAddress());
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            this.serviceName(instance.getServiceName());
            this.serviceId(instance.getServiceId());
            this.serviceAddress(instance.getServiceAddress());
            Optional<Boolean> serviceEnableTagOverrideOptional = instance.getServiceEnableTagOverride();
            if (serviceEnableTagOverrideOptional.isPresent()) {
                this.serviceEnableTagOverride(serviceEnableTagOverrideOptional);
            }
            this.servicePort(instance.getServicePort());
            this.addAllServiceTags(instance.getServiceTags());
            Optional<Map<String, String>> serviceMetaOptional = instance.getServiceMeta();
            if (serviceMetaOptional.isPresent()) {
                this.serviceMeta(serviceMetaOptional);
            }
            if ((nodeMetaOptional = instance.getNodeMeta()).isPresent()) {
                this.nodeMeta(nodeMetaOptional);
            }
            return this;
        }

        public final Builder node(String node) {
            this.node = (String)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder address(String address) {
            this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = (String)Preconditions.checkNotNull((Object)datacenter, (Object)"datacenter");
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        public final Builder serviceName(String serviceName) {
            this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder serviceId(String serviceId) {
            this.serviceId = (String)Preconditions.checkNotNull((Object)serviceId, (Object)"serviceId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder serviceAddress(String serviceAddress) {
            this.serviceAddress = (String)Preconditions.checkNotNull((Object)serviceAddress, (Object)"serviceAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder serviceEnableTagOverride(boolean serviceEnableTagOverride) {
            this.serviceEnableTagOverride = serviceEnableTagOverride;
            return this;
        }

        public final Builder serviceEnableTagOverride(Optional<Boolean> serviceEnableTagOverride) {
            this.serviceEnableTagOverride = serviceEnableTagOverride.orElse(null);
            return this;
        }

        public final Builder servicePort(int servicePort) {
            this.servicePort = servicePort;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder addServiceTags(String element) {
            this.serviceTagsBuilder.add((Object)element);
            return this;
        }

        public final Builder addServiceTags(String ... elements) {
            this.serviceTagsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder serviceTags(Iterable<String> elements) {
            this.serviceTagsBuilder = ImmutableList.builder();
            return this.addAllServiceTags(elements);
        }

        public final Builder addAllServiceTags(Iterable<String> elements) {
            this.serviceTagsBuilder.addAll(elements);
            return this;
        }

        public final Builder serviceMeta(Map<String, String> serviceMeta) {
            this.serviceMeta = (Map)Preconditions.checkNotNull(serviceMeta, (Object)"serviceMeta");
            return this;
        }

        public final Builder serviceMeta(Optional<Map<String, String>> serviceMeta) {
            this.serviceMeta = serviceMeta.orElse(null);
            return this;
        }

        public final Builder nodeMeta(Map<String, String> nodeMeta) {
            this.nodeMeta = (Map)Preconditions.checkNotNull(nodeMeta, (Object)"nodeMeta");
            return this;
        }

        public final Builder nodeMeta(Optional<Map<String, String>> nodeMeta) {
            this.nodeMeta = nodeMeta.orElse(null);
            return this;
        }

        public ImmutableCatalogService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.serviceEnableTagOverride, this.servicePort, this.serviceTagsBuilder.build(), this.serviceMeta, this.nodeMeta);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("serviceName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("serviceId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("serviceAddress");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("servicePort");
            }
            return "Cannot build CatalogService, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends CatalogService {
        @Nullable
        String node;
        @Nullable
        String address;
        Optional<String> datacenter = Optional.empty();
        @Nullable
        String serviceName;
        @Nullable
        String serviceId;
        @Nullable
        String serviceAddress;
        Optional<Boolean> serviceEnableTagOverride = Optional.empty();
        @Nullable
        Integer servicePort;
        List<String> serviceTags = ImmutableList.of();
        Optional<Map<String, String>> serviceMeta = Optional.empty();
        Optional<Map<String, String>> nodeMeta = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(Optional<String> datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="ServiceName")
        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @JsonProperty(value="ServiceID")
        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @JsonProperty(value="ServiceAddress")
        public void setServiceAddress(String serviceAddress) {
            this.serviceAddress = serviceAddress;
        }

        @JsonProperty(value="ServiceEnableTagOverride")
        public void setServiceEnableTagOverride(Optional<Boolean> serviceEnableTagOverride) {
            this.serviceEnableTagOverride = serviceEnableTagOverride;
        }

        @JsonProperty(value="ServicePort")
        public void setServicePort(int servicePort) {
            this.servicePort = servicePort;
        }

        @JsonProperty(value="ServiceTags")
        public void setServiceTags(List<String> serviceTags) {
            this.serviceTags = serviceTags;
        }

        @JsonProperty(value="ServiceMeta")
        public void setServiceMeta(Optional<Map<String, String>> serviceMeta) {
            this.serviceMeta = serviceMeta;
        }

        @JsonProperty(value="NodeMeta")
        public void setNodeMeta(Optional<Map<String, String>> nodeMeta) {
            this.nodeMeta = nodeMeta;
        }

        @Override
        public String getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDatacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getServiceEnableTagOverride() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getServicePort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getServiceTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Map<String, String>> getServiceMeta() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Map<String, String>> getNodeMeta() {
            throw new UnsupportedOperationException();
        }
    }
}

