/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.google.common.collect.ImmutableMap;
import com.orbitz.consul.BaseClient;
import com.orbitz.consul.async.Callback;
import com.orbitz.consul.config.ClientConfig;
import com.orbitz.consul.model.query.PreparedQuery;
import com.orbitz.consul.model.query.QueryId;
import com.orbitz.consul.model.query.QueryResults;
import com.orbitz.consul.model.query.StoredQuery;
import com.orbitz.consul.option.QueryOptions;
import com.orbitz.consul.util.Http;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public class PreparedQueryClient
extends BaseClient {
    private final Api api;

    PreparedQueryClient(Retrofit retrofit, ClientConfig config) {
        super(config);
        this.api = (Api)retrofit.create(Api.class);
    }

    public String createPreparedQuery(PreparedQuery preparedQuery) {
        return this.createPreparedQuery(preparedQuery, null);
    }

    public String createPreparedQuery(PreparedQuery preparedQuery, String dc) {
        return Http.extract(this.api.createPreparedQuery(preparedQuery, this.dcQuery(dc)), new Integer[0]).getId();
    }

    private Map<String, String> dcQuery(String dc) {
        return dc != null ? ImmutableMap.of((Object)"dc", (Object)dc) : Collections.emptyMap();
    }

    public List<StoredQuery> getPreparedQueries() {
        return this.getPreparedQueries(null);
    }

    public List<StoredQuery> getPreparedQueries(String dc) {
        return Http.extract(this.api.getPreparedQueries(this.dcQuery(dc)), new Integer[0]);
    }

    public Optional<StoredQuery> getPreparedQuery(String id) {
        return this.getPreparedQuery(id, null);
    }

    public Optional<StoredQuery> getPreparedQuery(String id, String dc) {
        List<StoredQuery> result = Http.extract(this.api.getPreparedQuery(id, this.dcQuery(dc)), new Integer[0]);
        return result.isEmpty() ? Optional.empty() : Optional.of(result.get(0));
    }

    public QueryResults execute(String nameOrId) {
        return Http.extract(this.api.execute(nameOrId, Collections.emptyMap()), new Integer[0]);
    }

    public void execute(String nameOrId, QueryOptions options, Callback<QueryResults> callback) {
        Http.extractBasicResponse(this.api.execute(nameOrId, options.toQuery()), callback, new Integer[0]);
    }

    static interface Api {
        @GET(value="query")
        public Call<List<StoredQuery>> getPreparedQueries(@QueryMap Map<String, String> var1);

        @POST(value="query")
        public Call<QueryId> createPreparedQuery(@Body PreparedQuery var1, @QueryMap Map<String, String> var2);

        @GET(value="query/{id}")
        public Call<List<StoredQuery>> getPreparedQuery(@Path(value="id") String var1, @QueryMap Map<String, String> var2);

        @GET(value="query/{nameOrId}/execute")
        public Call<QueryResults> execute(@Path(value="nameOrId") String var1, @QueryMap Map<String, Object> var2);
    }
}

