package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.health.Node;
import com.orbitz.consul.model.health.Service;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link CatalogNode}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableCatalogNode.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "CatalogNode"})
public final class ImmutableCatalogNode extends CatalogNode {
  private final Node node;
  private final ImmutableMap<String, Service> services;

  private ImmutableCatalogNode(
      Node node,
      ImmutableMap<String, Service> services) {
    this.node = node;
    this.services = services;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public Node getNode() {
    return node;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code services} attribute
   */
  @JsonProperty("Services")
  @Override
  public ImmutableMap<String, Service> getServices() {
    return services;
  }
  
  /**
   * Copy current immutable object by setting value for {@link CatalogNode#getNode() node}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for node
   * @return modified copy of the {@code this} object
   */
  public final ImmutableCatalogNode withNode(Node value) {
    if (this.node == value) {
      return this;
    }
    Node newValue = Preconditions.checkNotNull(value);
    return new ImmutableCatalogNode(newValue, this.services);
  }
  
  /**
   * Copy current immutable object by replacing {@link CatalogNode#getServices() services} map with specified map.
   * Nulls are not permitted as keys or values.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries to be added to services map
   * @return modified copy of {@code this} object
   */
  public final ImmutableCatalogNode withServices(Map<String, ? extends Service> entries) {
    if (this.services == entries) {
      return this;
    }
    ImmutableMap<String, Service> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableCatalogNode(this.node, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableCatalogNode} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableCatalogNode && equalTo((ImmutableCatalogNode) another));
  }
  
  private boolean equalTo(ImmutableCatalogNode another) {
    return node.equals(another.node)
        && services.equals(another.services);
  }
  
  /**
   * Computes hash code from attributes: {@code node}, {@code services}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + node.hashCode();
    h = h * 17 + services.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code CatalogNode{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CatalogNode")
        .add("node", node)
        .add("services", services)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableCatalogNode fromAllAttributes(
      @JsonProperty("Node") Node node,
      @JsonProperty("Services") Map<String, Service> services) {
    ImmutableCatalogNode.Builder builder = ImmutableCatalogNode.builder();
    if (node != null) {
      builder.node(node);
    }
    if (services != null) {
      builder.putAllServices(services);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link CatalogNode}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable CatalogNode instance
   */
  public static ImmutableCatalogNode copyOf(CatalogNode instance) {
    if (instance instanceof ImmutableCatalogNode) {
      return (ImmutableCatalogNode) instance;
    }
    return ImmutableCatalogNode.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.catalog.ImmutableCatalogNode}.
   * @return new ImmutableCatalogNode builder
   */
  public static ImmutableCatalogNode.Builder builder() {
    return new ImmutableCatalogNode.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.catalog.ImmutableCatalogNode}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_NODE = 0x1L;
    private long initializedBitset;
  
    private Node node;
    private ImmutableMap.Builder<String, Service> servicesBuilder = ImmutableMap.builder();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link CatalogNode} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(CatalogNode instance) {
      Preconditions.checkNotNull(instance);
      node(instance.getNode());
      putAllServices(instance.getServices());
      return this;
    }
  
    /**
     * Initializes value for {@link CatalogNode#getNode() node}.
     * @param node value for node
     * @return {@code this} builder for chained invocation
     */
    public final Builder node(Node node) {
      this.node = Preconditions.checkNotNull(node);
      initializedBitset |= INITIALIZED_BIT_NODE;
      return this;
    }
  
    /**
     * Put one entry to {@link CatalogNode#getServices() services} map.
     * @param key the key in services map
     * @param value the associated value in services map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putServices(String key, Service value) {
      servicesBuilder.put(key, value);
      return this;
    }
  
    /**
     * Put one entry to {@link CatalogNode#getServices() services} map. Nulls are not permitted
     * @param entry the key and value entry
     * @return {@code this} builder for chained invocation
     */
    public final Builder putServices(Map.Entry<String, ? extends Service> entry) {
      servicesBuilder.put(entry);
      return this;
    }
  
    /**
     * Sets or replaces all mappings from specified map as entries for {@link CatalogNode#getServices() services} map. Nulls are not permitted
     * @param entries to be added to services map
     * @return {@code this} builder for chained invocation
     */
    public final Builder services(Map<String, ? extends Service> entries) {
      servicesBuilder = ImmutableMap.builder();
      return putAllServices(entries);
    }
  
    /**
     * Put all mappings from specified map as entries to {@link CatalogNode#getServices() services} map. Nulls are not permitted
     * @param entries to be added to services map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putAllServices(Map<String, ? extends Service> entries) {
      servicesBuilder.putAll(entries);
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.catalog.ImmutableCatalogNode}.
     * @return immutable instance of CatalogNode
     */
    public ImmutableCatalogNode build() {
      checkRequiredAttributes();
      return new ImmutableCatalogNode(node, servicesBuilder.build());
    }
  
    private boolean nodeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NODE) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nodeIsSet()) {
        attributes.add("node");
      }
      return "Cannot build CatalogNode, some of required attributes are not set " + attributes;
    }
  }
}
