package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link EventOptions}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableEventOptions.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "EventOptions"})
public final class ImmutableEventOptions extends EventOptions {
  private final Optional<String> datacenter;
  private final Optional<String> nodeFilter;
  private final Optional<String> serviceFilter;
  private final Optional<String> tagFilter;

  private ImmutableEventOptions(
      Optional<String> datacenter,
      Optional<String> nodeFilter,
      Optional<String> serviceFilter,
      Optional<String> tagFilter) {
    this.datacenter = datacenter;
    this.nodeFilter = nodeFilter;
    this.serviceFilter = serviceFilter;
    this.tagFilter = tagFilter;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code datacenter} attribute
   */
  @Override
  public Optional<String> getDatacenter() {
    return datacenter;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code nodeFilter} attribute
   */
  @Override
  public Optional<String> getNodeFilter() {
    return nodeFilter;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code serviceFilter} attribute
   */
  @Override
  public Optional<String> getServiceFilter() {
    return serviceFilter;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code tagFilter} attribute
   */
  @Override
  public Optional<String> getTagFilter() {
    return tagFilter;
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link EventOptions#getDatacenter() datacenter}.
   * @param value value for datacenter
   * @return modified copy of {@code this} object
   */
  public final ImmutableEventOptions withDatacenter(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableEventOptions(newValue, this.nodeFilter, this.serviceFilter, this.tagFilter);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link EventOptions#getDatacenter() datacenter}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for datacenter
   * @return modified copy of {@code this} object
   */
  public final ImmutableEventOptions withDatacenter(Optional<String> optional) {
    if (this.datacenter == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableEventOptions(newValue, this.nodeFilter, this.serviceFilter, this.tagFilter);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link EventOptions#getNodeFilter() nodeFilter}.
   * @param value value for nodeFilter
   * @return modified copy of {@code this} object
   */
  public final ImmutableEventOptions withNodeFilter(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableEventOptions(this.datacenter, newValue, this.serviceFilter, this.tagFilter);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link EventOptions#getNodeFilter() nodeFilter}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for nodeFilter
   * @return modified copy of {@code this} object
   */
  public final ImmutableEventOptions withNodeFilter(Optional<String> optional) {
    if (this.nodeFilter == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableEventOptions(this.datacenter, newValue, this.serviceFilter, this.tagFilter);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link EventOptions#getServiceFilter() serviceFilter}.
   * @param value value for serviceFilter
   * @return modified copy of {@code this} object
   */
  public final ImmutableEventOptions withServiceFilter(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableEventOptions(this.datacenter, this.nodeFilter, newValue, this.tagFilter);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link EventOptions#getServiceFilter() serviceFilter}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for serviceFilter
   * @return modified copy of {@code this} object
   */
  public final ImmutableEventOptions withServiceFilter(Optional<String> optional) {
    if (this.serviceFilter == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableEventOptions(this.datacenter, this.nodeFilter, newValue, this.tagFilter);
  }
  
  /**
   * Copy current immutable object by setting present value for optional {@link EventOptions#getTagFilter() tagFilter}.
   * @param value value for tagFilter
   * @return modified copy of {@code this} object
   */
  public final ImmutableEventOptions withTagFilter(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableEventOptions(this.datacenter, this.nodeFilter, this.serviceFilter, newValue);
  }
  
  /**
   * Copy current immutable object by setting optional value for {@link EventOptions#getTagFilter() tagFilter}.
   * Shallow reference equality check on optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional value for tagFilter
   * @return modified copy of {@code this} object
   */
  public final ImmutableEventOptions withTagFilter(Optional<String> optional) {
    if (this.tagFilter == optional) {
      return this;
    }
    Optional<String> newValue = Preconditions.checkNotNull(optional);
    return new ImmutableEventOptions(this.datacenter, this.nodeFilter, this.serviceFilter, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableEventOptions} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableEventOptions && equalTo((ImmutableEventOptions) another));
  }
  
  private boolean equalTo(ImmutableEventOptions another) {
    return datacenter.equals(another.datacenter)
        && nodeFilter.equals(another.nodeFilter)
        && serviceFilter.equals(another.serviceFilter)
        && tagFilter.equals(another.tagFilter);
  }
  
  /**
   * Computes hash code from attributes: {@code datacenter}, {@code nodeFilter}, {@code serviceFilter}, {@code tagFilter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + datacenter.hashCode();
    h = h * 17 + nodeFilter.hashCode();
    h = h * 17 + serviceFilter.hashCode();
    h = h * 17 + tagFilter.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code EventOptions{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("EventOptions")
        .add("datacenter", datacenter)
        .add("nodeFilter", nodeFilter)
        .add("serviceFilter", serviceFilter)
        .add("tagFilter", tagFilter)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link EventOptions}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable EventOptions instance
   */
  public static ImmutableEventOptions copyOf(EventOptions instance) {
    if (instance instanceof ImmutableEventOptions) {
      return (ImmutableEventOptions) instance;
    }
    return ImmutableEventOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.option.ImmutableEventOptions}.
   * @return new ImmutableEventOptions builder
   */
  public static ImmutableEventOptions.Builder builder() {
    return new ImmutableEventOptions.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.option.ImmutableEventOptions}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
  
    private Optional<String> datacenter = Optional.absent();
    private Optional<String> nodeFilter = Optional.absent();
    private Optional<String> serviceFilter = Optional.absent();
    private Optional<String> tagFilter = Optional.absent();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link EventOptions} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(EventOptions instance) {
      Preconditions.checkNotNull(instance);
      Optional<String> datacenterOptional = instance.getDatacenter();
      if (datacenterOptional.isPresent()) {
        datacenter(datacenterOptional);
      }
      Optional<String> nodeFilterOptional = instance.getNodeFilter();
      if (nodeFilterOptional.isPresent()) {
        nodeFilter(nodeFilterOptional);
      }
      Optional<String> serviceFilterOptional = instance.getServiceFilter();
      if (serviceFilterOptional.isPresent()) {
        serviceFilter(serviceFilterOptional);
      }
      Optional<String> tagFilterOptional = instance.getTagFilter();
      if (tagFilterOptional.isPresent()) {
        tagFilter(tagFilterOptional);
      }
      return this;
    }
  
    /**
     * Initializes present value for optional {@link EventOptions#getDatacenter() datacenter}.
     * @param datacenter value for datacenter
     * @return {@code this} builder for chained invocation
     */
    public final Builder datacenter(String datacenter) {
      this.datacenter = Optional.of(datacenter);
      return this;
    }
  
    /**
     * Initializes optional value for {@link EventOptions#getDatacenter() datacenter}.
     * @param datacenter value for datacenter
     * @return {@code this} builder for chained invocation
     */
    public final Builder datacenter(Optional<String> datacenter) {
      this.datacenter = Preconditions.checkNotNull(datacenter);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link EventOptions#getNodeFilter() nodeFilter}.
     * @param nodeFilter value for nodeFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder nodeFilter(String nodeFilter) {
      this.nodeFilter = Optional.of(nodeFilter);
      return this;
    }
  
    /**
     * Initializes optional value for {@link EventOptions#getNodeFilter() nodeFilter}.
     * @param nodeFilter value for nodeFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder nodeFilter(Optional<String> nodeFilter) {
      this.nodeFilter = Preconditions.checkNotNull(nodeFilter);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link EventOptions#getServiceFilter() serviceFilter}.
     * @param serviceFilter value for serviceFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceFilter(String serviceFilter) {
      this.serviceFilter = Optional.of(serviceFilter);
      return this;
    }
  
    /**
     * Initializes optional value for {@link EventOptions#getServiceFilter() serviceFilter}.
     * @param serviceFilter value for serviceFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceFilter(Optional<String> serviceFilter) {
      this.serviceFilter = Preconditions.checkNotNull(serviceFilter);
      return this;
    }
  
    /**
     * Initializes present value for optional {@link EventOptions#getTagFilter() tagFilter}.
     * @param tagFilter value for tagFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder tagFilter(String tagFilter) {
      this.tagFilter = Optional.of(tagFilter);
      return this;
    }
  
    /**
     * Initializes optional value for {@link EventOptions#getTagFilter() tagFilter}.
     * @param tagFilter value for tagFilter
     * @return {@code this} builder for chained invocation
     */
    public final Builder tagFilter(Optional<String> tagFilter) {
      this.tagFilter = Preconditions.checkNotNull(tagFilter);
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.option.ImmutableEventOptions}.
     * @return immutable instance of EventOptions
     */
    public ImmutableEventOptions build() {
      return new ImmutableEventOptions(datacenter, nodeFilter, serviceFilter, tagFilter);
    }
  }
}
