package com.orbitz.consul.model.health;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link ServiceHealth}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ImmutableServiceHealth.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "ServiceHealth"})
public final class ImmutableServiceHealth extends ServiceHealth {
  private final Node node;
  private final Service service;
  private final ImmutableList<HealthCheck> checks;

  private ImmutableServiceHealth(
      Node node,
      Service service,
      ImmutableList<HealthCheck> checks) {
    this.node = node;
    this.service = service;
    this.checks = checks;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public Node getNode() {
    return node;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code service} attribute
   */
  @JsonProperty("Service")
  @Override
  public Service getService() {
    return service;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code checks} attribute
   */
  @JsonDeserialize(as = ArrayList.class, contentAs = HealthCheck.class)
  @JsonProperty("Checks")
  @Override
  public ImmutableList<HealthCheck> getChecks() {
    return checks;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ServiceHealth#getNode() node}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for node
   * @return modified copy of the {@code this} object
   */
  public final ImmutableServiceHealth withNode(Node value) {
    if (this.node == value) {
      return this;
    }
    Node newValue = Preconditions.checkNotNull(value);
    return new ImmutableServiceHealth(newValue, this.service, this.checks);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ServiceHealth#getService() service}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for service
   * @return modified copy of the {@code this} object
   */
  public final ImmutableServiceHealth withService(Service value) {
    if (this.service == value) {
      return this;
    }
    Service newValue = Preconditions.checkNotNull(value);
    return new ImmutableServiceHealth(this.node, newValue, this.checks);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ServiceHealth#getChecks() checks}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableServiceHealth withChecks(HealthCheck... elements) {
    ImmutableList<HealthCheck> newValue = ImmutableList.copyOf(elements);
    return new ImmutableServiceHealth(this.node, this.service, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ServiceHealth#getChecks() checks}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of checks elements to set
   * @return modified copy of {@code this} object
   */
  public final ImmutableServiceHealth withChecks(Iterable<? extends HealthCheck> elements) {
    if (this.checks == elements) {
      return this;
    }
    ImmutableList<HealthCheck> newValue = ImmutableList.copyOf(elements);
    return new ImmutableServiceHealth(this.node, this.service, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ImmutableServiceHealth} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    return this == another
        || (another instanceof ImmutableServiceHealth && equalTo((ImmutableServiceHealth) another));
  }
  
  private boolean equalTo(ImmutableServiceHealth another) {
    return node.equals(another.node)
        && service.equals(another.service)
        && checks.equals(another.checks);
  }
  
  /**
   * Computes hash code from attributes: {@code node}, {@code service}, {@code checks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + node.hashCode();
    h = h * 17 + service.hashCode();
    h = h * 17 + checks.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code ServiceHealth{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ServiceHealth")
        .add("node", node)
        .add("service", service)
        .add("checks", checks)
        .toString();
  }
  
  @JsonCreator
  public static ImmutableServiceHealth fromAllAttributes(
      @JsonProperty("Node") Node node,
      @JsonProperty("Service") Service service,
      @JsonDeserialize(as = ArrayList.class, contentAs = HealthCheck.class)
      @JsonProperty("Checks") List<HealthCheck> checks) {
    ImmutableServiceHealth.Builder builder = ImmutableServiceHealth.builder();
    if (node != null) {
      builder.node(node);
    }
    if (service != null) {
      builder.service(service);
    }
    if (checks != null) {
      builder.addAllChecks(checks);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ServiceHealth}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ServiceHealth instance
   */
  public static ImmutableServiceHealth copyOf(ServiceHealth instance) {
    if (instance instanceof ImmutableServiceHealth) {
      return (ImmutableServiceHealth) instance;
    }
    return ImmutableServiceHealth.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates builder for {@link com.orbitz.consul.model.health.ImmutableServiceHealth}.
   * @return new ImmutableServiceHealth builder
   */
  public static ImmutableServiceHealth.Builder builder() {
    return new ImmutableServiceHealth.Builder();
  }
  
  /**
   * Builds instances of {@link com.orbitz.consul.model.health.ImmutableServiceHealth}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_NODE = 0x1L;
    private static final long INITIALIZED_BIT_SERVICE = 0x2L;
    private long initializedBitset;
  
    private Node node;
    private Service service;
    private ImmutableList.Builder<HealthCheck> checksBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link ServiceHealth} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(ServiceHealth instance) {
      Preconditions.checkNotNull(instance);
      node(instance.getNode());
      service(instance.getService());
      addAllChecks(instance.getChecks());
      return this;
    }
  
    /**
     * Initializes value for {@link ServiceHealth#getNode() node}.
     * @param node value for node
     * @return {@code this} builder for chained invocation
     */
    public final Builder node(Node node) {
      this.node = Preconditions.checkNotNull(node);
      initializedBitset |= INITIALIZED_BIT_NODE;
      return this;
    }
  
    /**
     * Initializes value for {@link ServiceHealth#getService() service}.
     * @param service value for service
     * @return {@code this} builder for chained invocation
     */
    public final Builder service(Service service) {
      this.service = Preconditions.checkNotNull(service);
      initializedBitset |= INITIALIZED_BIT_SERVICE;
      return this;
    }
  
    /**
     * Adds one element to {@link ServiceHealth#getChecks() checks} list.
     * @param element checks element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addChecks(HealthCheck element) {
      checksBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link ServiceHealth#getChecks() checks} list.
     * @param elements array of checks elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addChecks(HealthCheck... elements) {
      checksBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link ServiceHealth#getChecks() checks} list.
     * @param elements iterable of checks elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder checks(Iterable<? extends HealthCheck> elements) {
      checksBuilder = ImmutableList.builder();
      return addAllChecks(elements);
    }
  
    /**
     * Adds elements to {@link ServiceHealth#getChecks() checks} list.
     * @param elements iterable of checks elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllChecks(Iterable<? extends HealthCheck> elements) {
      checksBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link com.orbitz.consul.model.health.ImmutableServiceHealth}.
     * @return immutable instance of ServiceHealth
     */
    public ImmutableServiceHealth build() {
      checkRequiredAttributes();
      return new ImmutableServiceHealth(node, service, checksBuilder.build());
    }
  
    private boolean nodeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NODE) != 0;
    }
  
    private boolean serviceIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SERVICE) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nodeIsSet()) {
        attributes.add("node");
      }
      if (!serviceIsSet()) {
        attributes.add("service");
      }
      return "Cannot build ServiceHealth, some of required attributes are not set " + attributes;
    }
  }
}
