/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.event.Event;
import com.orbitz.consul.util.Base64EncodingDeserializer;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableEvent
extends Event {
    private final String id;
    private final String name;
    private final Optional<String> payload;
    private final Optional<String> nodeFilter;
    private final Optional<String> serviceFilter;
    private final Optional<String> tagFilter;
    private final int version;
    private final Long lTime;

    private ImmutableEvent(String id, String name, Optional<String> payload, Optional<String> nodeFilter, Optional<String> serviceFilter, Optional<String> tagFilter, int version, Long lTime) {
        this.id = id;
        this.name = name;
        this.payload = payload;
        this.nodeFilter = nodeFilter;
        this.serviceFilter = serviceFilter;
        this.tagFilter = tagFilter;
        this.version = version;
        this.lTime = lTime;
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Payload")
    @JsonDeserialize(using=Base64EncodingDeserializer.class)
    public Optional<String> getPayload() {
        return this.payload;
    }

    @Override
    @JsonProperty(value="NodeFilter")
    public Optional<String> getNodeFilter() {
        return this.nodeFilter;
    }

    @Override
    @JsonProperty(value="ServiceFilter")
    public Optional<String> getServiceFilter() {
        return this.serviceFilter;
    }

    @Override
    @JsonProperty(value="TagFilter")
    public Optional<String> getTagFilter() {
        return this.tagFilter;
    }

    @Override
    @JsonProperty(value="Version")
    public int getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="LTime")
    public Long getLTime() {
        return this.lTime;
    }

    public final ImmutableEvent withId(String value) {
        if (this.id.equals(value)) {
            return this;
        }
        return new ImmutableEvent((String)Preconditions.checkNotNull((Object)value, (Object)"id"), this.name, this.payload, this.nodeFilter, this.serviceFilter, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return new ImmutableEvent(this.id, (String)Preconditions.checkNotNull((Object)value, (Object)"name"), this.payload, this.nodeFilter, this.serviceFilter, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withPayload(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.payload.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, (Optional<String>)newValue, this.nodeFilter, this.serviceFilter, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withPayload(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"payload");
        if (this.payload.equals((Object)value)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, (Optional<String>)value, this.nodeFilter, this.serviceFilter, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withNodeFilter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.nodeFilter.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, (Optional<String>)newValue, this.serviceFilter, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withNodeFilter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"nodeFilter");
        if (this.nodeFilter.equals((Object)value)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, (Optional<String>)value, this.serviceFilter, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withServiceFilter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.serviceFilter.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, this.nodeFilter, (Optional<String>)newValue, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withServiceFilter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"serviceFilter");
        if (this.serviceFilter.equals((Object)value)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, this.nodeFilter, (Optional<String>)value, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withTagFilter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.tagFilter.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, this.nodeFilter, this.serviceFilter, (Optional<String>)newValue, this.version, this.lTime);
    }

    public final ImmutableEvent withTagFilter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"tagFilter");
        if (this.tagFilter.equals((Object)value)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, this.nodeFilter, this.serviceFilter, (Optional<String>)value, this.version, this.lTime);
    }

    public final ImmutableEvent withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, this.nodeFilter, this.serviceFilter, this.tagFilter, value, this.lTime);
    }

    public final ImmutableEvent withLTime(Long value) {
        if (this.lTime.equals(value)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, this.nodeFilter, this.serviceFilter, this.tagFilter, this.version, (Long)Preconditions.checkNotNull((Object)value, (Object)"lTime"));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEvent && this.equalTo((ImmutableEvent)another);
    }

    private boolean equalTo(ImmutableEvent another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.payload.equals(another.payload) && this.nodeFilter.equals(another.nodeFilter) && this.serviceFilter.equals(another.serviceFilter) && this.tagFilter.equals(another.tagFilter) && this.version == another.version && this.lTime.equals(another.lTime);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.payload.hashCode();
        h = h * 17 + this.nodeFilter.hashCode();
        h = h * 17 + this.serviceFilter.hashCode();
        h = h * 17 + this.tagFilter.hashCode();
        h = h * 17 + this.version;
        h = h * 17 + this.lTime.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Event").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("payload", this.payload.orNull()).add("nodeFilter", this.nodeFilter.orNull()).add("serviceFilter", this.serviceFilter.orNull()).add("tagFilter", this.tagFilter.orNull()).add("version", this.version).add("lTime", (Object)this.lTime).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableEvent fromJson(Json json) {
        Builder builder = ImmutableEvent.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.payload != null) {
            builder.payload(json.payload);
        }
        if (json.nodeFilter != null) {
            builder.nodeFilter(json.nodeFilter);
        }
        if (json.serviceFilter != null) {
            builder.serviceFilter(json.serviceFilter);
        }
        if (json.tagFilter != null) {
            builder.tagFilter(json.tagFilter);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.lTime != null) {
            builder.lTime(json.lTime);
        }
        return builder.build();
    }

    public static ImmutableEvent copyOf(Event instance) {
        if (instance instanceof ImmutableEvent) {
            return (ImmutableEvent)instance;
        }
        return ImmutableEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_VERSION = 4L;
        private static final long INIT_BIT_L_TIME = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        private Optional<String> payload = Optional.absent();
        private Optional<String> nodeFilter = Optional.absent();
        private Optional<String> serviceFilter = Optional.absent();
        private Optional<String> tagFilter = Optional.absent();
        private int version;
        @Nullable
        private Long lTime;

        private Builder() {
        }

        public final Builder from(Event instance) {
            Optional<String> tagFilterOptional;
            Optional<String> serviceFilterOptional;
            Optional<String> nodeFilterOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.id(instance.getId());
            this.name(instance.getName());
            Optional<String> payloadOptional = instance.getPayload();
            if (payloadOptional.isPresent()) {
                this.payload(payloadOptional);
            }
            if ((nodeFilterOptional = instance.getNodeFilter()).isPresent()) {
                this.nodeFilter(nodeFilterOptional);
            }
            if ((serviceFilterOptional = instance.getServiceFilter()).isPresent()) {
                this.serviceFilter(serviceFilterOptional);
            }
            if ((tagFilterOptional = instance.getTagFilter()).isPresent()) {
                this.tagFilter(tagFilterOptional);
            }
            this.version(instance.getVersion());
            this.lTime(instance.getLTime());
            return this;
        }

        public final Builder id(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder payload(String payload) {
            this.payload = Optional.of((Object)payload);
            return this;
        }

        public final Builder payload(Optional<String> payload) {
            this.payload = (Optional)Preconditions.checkNotNull(payload, (Object)"payload");
            return this;
        }

        public final Builder nodeFilter(String nodeFilter) {
            this.nodeFilter = Optional.of((Object)nodeFilter);
            return this;
        }

        public final Builder nodeFilter(Optional<String> nodeFilter) {
            this.nodeFilter = (Optional)Preconditions.checkNotNull(nodeFilter, (Object)"nodeFilter");
            return this;
        }

        public final Builder serviceFilter(String serviceFilter) {
            this.serviceFilter = Optional.of((Object)serviceFilter);
            return this;
        }

        public final Builder serviceFilter(Optional<String> serviceFilter) {
            this.serviceFilter = (Optional)Preconditions.checkNotNull(serviceFilter, (Object)"serviceFilter");
            return this;
        }

        public final Builder tagFilter(String tagFilter) {
            this.tagFilter = Optional.of((Object)tagFilter);
            return this;
        }

        public final Builder tagFilter(Optional<String> tagFilter) {
            this.tagFilter = (Optional)Preconditions.checkNotNull(tagFilter, (Object)"tagFilter");
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder lTime(Long lTime) {
            this.lTime = (Long)Preconditions.checkNotNull((Object)lTime, (Object)"lTime");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEvent(this.id, this.name, this.payload, this.nodeFilter, this.serviceFilter, this.tagFilter, this.version, this.lTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("lTime");
            }
            return "Cannot build Event, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Event {
        @Nullable
        String id;
        @Nullable
        String name;
        Optional<String> payload = Optional.absent();
        Optional<String> nodeFilter = Optional.absent();
        Optional<String> serviceFilter = Optional.absent();
        Optional<String> tagFilter = Optional.absent();
        @Nullable
        Integer version;
        @Nullable
        Long lTime;

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Payload")
        @JsonDeserialize(using=Base64EncodingDeserializer.class)
        public void setPayload(Optional<String> payload) {
            this.payload = payload;
        }

        @JsonProperty(value="NodeFilter")
        public void setNodeFilter(Optional<String> nodeFilter) {
            this.nodeFilter = nodeFilter;
        }

        @JsonProperty(value="ServiceFilter")
        public void setServiceFilter(Optional<String> serviceFilter) {
            this.serviceFilter = serviceFilter;
        }

        @JsonProperty(value="TagFilter")
        public void setTagFilter(Optional<String> tagFilter) {
            this.tagFilter = tagFilter;
        }

        @JsonProperty(value="Version")
        public void setVersion(int version) {
            this.version = version;
        }

        @JsonProperty(value="LTime")
        public void setLTime(Long lTime) {
            this.lTime = lTime;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPayload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNodeFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getServiceFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTagFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getLTime() {
            throw new UnsupportedOperationException();
        }
    }
}

