/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import com.orbitz.consul.option.DeleteOptions;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableDeleteOptions
extends DeleteOptions {
    private final Optional<Long> cas;
    private final Optional<Boolean> recurse;
    private final Optional<String> datacenter;
    private final boolean isRecurse;

    private ImmutableDeleteOptions(Optional<Long> cas, Optional<Boolean> recurse, Optional<String> datacenter) {
        this.cas = cas;
        this.recurse = recurse;
        this.datacenter = datacenter;
        this.isRecurse = super.isRecurse();
    }

    @Override
    public Optional<Long> getCas() {
        return this.cas;
    }

    @Override
    public Optional<Boolean> getRecurse() {
        return this.recurse;
    }

    @Override
    public Optional<String> getDatacenter() {
        return this.datacenter;
    }

    @Override
    public boolean isRecurse() {
        return this.isRecurse;
    }

    public final ImmutableDeleteOptions withCas(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.cas.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableDeleteOptions((Optional<Long>)newValue, this.recurse, this.datacenter);
    }

    public final ImmutableDeleteOptions withCas(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"cas");
        if (this.cas.equals((Object)value)) {
            return this;
        }
        return new ImmutableDeleteOptions((Optional<Long>)value, this.recurse, this.datacenter);
    }

    public final ImmutableDeleteOptions withRecurse(boolean value) {
        Optional newValue = Optional.of((Object)value);
        if (this.recurse.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableDeleteOptions(this.cas, (Optional<Boolean>)newValue, this.datacenter);
    }

    public final ImmutableDeleteOptions withRecurse(Optional<Boolean> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"recurse");
        if (this.recurse.equals((Object)value)) {
            return this;
        }
        return new ImmutableDeleteOptions(this.cas, (Optional<Boolean>)value, this.datacenter);
    }

    public final ImmutableDeleteOptions withDatacenter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.datacenter.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableDeleteOptions(this.cas, this.recurse, (Optional<String>)newValue);
    }

    public final ImmutableDeleteOptions withDatacenter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"datacenter");
        if (this.datacenter.equals((Object)value)) {
            return this;
        }
        return new ImmutableDeleteOptions(this.cas, this.recurse, (Optional<String>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeleteOptions && this.equalTo((ImmutableDeleteOptions)another);
    }

    private boolean equalTo(ImmutableDeleteOptions another) {
        return this.cas.equals(another.cas) && this.recurse.equals(another.recurse) && this.datacenter.equals(another.datacenter) && this.isRecurse == another.isRecurse;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.cas.hashCode();
        h = h * 17 + this.recurse.hashCode();
        h = h * 17 + this.datacenter.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.isRecurse);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DeleteOptions").omitNullValues().add("cas", this.cas.orNull()).add("recurse", this.recurse.orNull()).add("datacenter", this.datacenter.orNull()).add("isRecurse", this.isRecurse).toString();
    }

    public static ImmutableDeleteOptions copyOf(DeleteOptions instance) {
        if (instance instanceof ImmutableDeleteOptions) {
            return (ImmutableDeleteOptions)instance;
        }
        return ImmutableDeleteOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private Optional<Long> cas = Optional.absent();
        private Optional<Boolean> recurse = Optional.absent();
        private Optional<String> datacenter = Optional.absent();

        private Builder() {
        }

        public final Builder from(DeleteOptions instance) {
            Optional<String> datacenterOptional;
            Optional<Boolean> recurseOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<Long> casOptional = instance.getCas();
            if (casOptional.isPresent()) {
                this.cas(casOptional);
            }
            if ((recurseOptional = instance.getRecurse()).isPresent()) {
                this.recurse(recurseOptional);
            }
            if ((datacenterOptional = instance.getDatacenter()).isPresent()) {
                this.datacenter(datacenterOptional);
            }
            return this;
        }

        public final Builder cas(long cas) {
            this.cas = Optional.of((Object)cas);
            return this;
        }

        public final Builder cas(Optional<Long> cas) {
            this.cas = (Optional)Preconditions.checkNotNull(cas, (Object)"cas");
            return this;
        }

        public final Builder recurse(boolean recurse) {
            this.recurse = Optional.of((Object)recurse);
            return this;
        }

        public final Builder recurse(Optional<Boolean> recurse) {
            this.recurse = (Optional)Preconditions.checkNotNull(recurse, (Object)"recurse");
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = Optional.of((Object)datacenter);
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = (Optional)Preconditions.checkNotNull(datacenter, (Object)"datacenter");
            return this;
        }

        public ImmutableDeleteOptions build() {
            return new ImmutableDeleteOptions(this.cas, this.recurse, this.datacenter);
        }
    }
}

