/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.kv;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.kv.Operation;
import com.orbitz.consul.util.Base64EncodingDeserializer;
import com.orbitz.consul.util.Base64EncodingSerializer;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableOperation
extends Operation {
    private final String verb;
    private final Optional<String> key;
    private final Optional<String> value;
    private final Optional<Long> flags;
    private final Optional<BigInteger> index;
    private final Optional<String> session;

    private ImmutableOperation(String verb, Optional<String> key, Optional<String> value, Optional<Long> flags, Optional<BigInteger> index, Optional<String> session) {
        this.verb = verb;
        this.key = key;
        this.value = value;
        this.flags = flags;
        this.index = index;
        this.session = session;
    }

    @Override
    @JsonProperty(value="Verb")
    public String verb() {
        return this.verb;
    }

    @Override
    @JsonProperty(value="Key")
    public Optional<String> key() {
        return this.key;
    }

    @Override
    @JsonProperty(value="Value")
    @JsonSerialize(using=Base64EncodingSerializer.class)
    @JsonDeserialize(using=Base64EncodingDeserializer.class)
    public Optional<String> value() {
        return this.value;
    }

    @Override
    @JsonProperty(value="Flags")
    public Optional<Long> flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="Index")
    public Optional<BigInteger> index() {
        return this.index;
    }

    @Override
    @JsonProperty(value="Session")
    public Optional<String> session() {
        return this.session;
    }

    public final ImmutableOperation withVerb(String value) {
        if (this.verb.equals(value)) {
            return this;
        }
        return new ImmutableOperation((String)Preconditions.checkNotNull((Object)value, (Object)"verb"), this.key, this.value, this.flags, this.index, this.session);
    }

    public final ImmutableOperation withKey(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.key.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableOperation(this.verb, (Optional<String>)newValue, this.value, this.flags, this.index, this.session);
    }

    public final ImmutableOperation withKey(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"key");
        if (this.key.equals((Object)value)) {
            return this;
        }
        return new ImmutableOperation(this.verb, (Optional<String>)value, this.value, this.flags, this.index, this.session);
    }

    public final ImmutableOperation withValue(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.value.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, (Optional<String>)newValue, this.flags, this.index, this.session);
    }

    public final ImmutableOperation withValue(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"value");
        if (this.value.equals((Object)value)) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, (Optional<String>)value, this.flags, this.index, this.session);
    }

    public final ImmutableOperation withFlags(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.flags.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, this.value, (Optional<Long>)newValue, this.index, this.session);
    }

    public final ImmutableOperation withFlags(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"flags");
        if (this.flags.equals((Object)value)) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, this.value, (Optional<Long>)value, this.index, this.session);
    }

    public final ImmutableOperation withIndex(BigInteger value) {
        Optional newValue = Optional.of((Object)value);
        if (this.index.isPresent() && this.index.get() == value) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, this.value, this.flags, (Optional<BigInteger>)newValue, this.session);
    }

    public final ImmutableOperation withIndex(Optional<BigInteger> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"index");
        if (!this.index.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.index.isPresent() && value.isPresent() && this.index.get() == value.get()) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, this.value, this.flags, (Optional<BigInteger>)value, this.session);
    }

    public final ImmutableOperation withSession(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.session.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, this.value, this.flags, this.index, (Optional<String>)newValue);
    }

    public final ImmutableOperation withSession(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"session");
        if (this.session.equals((Object)value)) {
            return this;
        }
        return new ImmutableOperation(this.verb, this.key, this.value, this.flags, this.index, (Optional<String>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOperation && this.equalTo((ImmutableOperation)another);
    }

    private boolean equalTo(ImmutableOperation another) {
        return this.verb.equals(another.verb) && this.key.equals(another.key) && this.value.equals(another.value) && this.flags.equals(another.flags) && this.index.equals(another.index) && this.session.equals(another.session);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.verb.hashCode();
        h = h * 17 + this.key.hashCode();
        h = h * 17 + this.value.hashCode();
        h = h * 17 + this.flags.hashCode();
        h = h * 17 + this.index.hashCode();
        h = h * 17 + this.session.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Operation").omitNullValues().add("verb", (Object)this.verb).add("key", this.key.orNull()).add("value", this.value.orNull()).add("flags", this.flags.orNull()).add("index", this.index.orNull()).add("session", this.session.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableOperation fromJson(Json json) {
        Builder builder = ImmutableOperation.builder();
        if (json.verb != null) {
            builder.verb(json.verb);
        }
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        if (json.index != null) {
            builder.index(json.index);
        }
        if (json.session != null) {
            builder.session(json.session);
        }
        return builder.build();
    }

    public static ImmutableOperation copyOf(Operation instance) {
        if (instance instanceof ImmutableOperation) {
            return (ImmutableOperation)instance;
        }
        return ImmutableOperation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VERB = 1L;
        private long initBits = 1L;
        @Nullable
        private String verb;
        private Optional<String> key = Optional.absent();
        private Optional<String> value = Optional.absent();
        private Optional<Long> flags = Optional.absent();
        private Optional<BigInteger> index = Optional.absent();
        private Optional<String> session = Optional.absent();

        private Builder() {
        }

        public final Builder from(Operation instance) {
            Optional<String> sessionOptional;
            Optional<BigInteger> indexOptional;
            Optional<Long> flagsOptional;
            Optional<String> valueOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.verb(instance.verb());
            Optional<String> keyOptional = instance.key();
            if (keyOptional.isPresent()) {
                this.key(keyOptional);
            }
            if ((valueOptional = instance.value()).isPresent()) {
                this.value(valueOptional);
            }
            if ((flagsOptional = instance.flags()).isPresent()) {
                this.flags(flagsOptional);
            }
            if ((indexOptional = instance.index()).isPresent()) {
                this.index(indexOptional);
            }
            if ((sessionOptional = instance.session()).isPresent()) {
                this.session(sessionOptional);
            }
            return this;
        }

        public final Builder verb(String verb) {
            this.verb = (String)Preconditions.checkNotNull((Object)verb, (Object)"verb");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder key(String key) {
            this.key = Optional.of((Object)key);
            return this;
        }

        public final Builder key(Optional<String> key) {
            this.key = (Optional)Preconditions.checkNotNull(key, (Object)"key");
            return this;
        }

        public final Builder value(String value) {
            this.value = Optional.of((Object)value);
            return this;
        }

        public final Builder value(Optional<String> value) {
            this.value = (Optional)Preconditions.checkNotNull(value, (Object)"value");
            return this;
        }

        public final Builder flags(long flags) {
            this.flags = Optional.of((Object)flags);
            return this;
        }

        public final Builder flags(Optional<Long> flags) {
            this.flags = (Optional)Preconditions.checkNotNull(flags, (Object)"flags");
            return this;
        }

        public final Builder index(BigInteger index) {
            this.index = Optional.of((Object)index);
            return this;
        }

        public final Builder index(Optional<BigInteger> index) {
            this.index = (Optional)Preconditions.checkNotNull(index, (Object)"index");
            return this;
        }

        public final Builder session(String session) {
            this.session = Optional.of((Object)session);
            return this;
        }

        public final Builder session(Optional<String> session) {
            this.session = (Optional)Preconditions.checkNotNull(session, (Object)"session");
            return this;
        }

        public ImmutableOperation build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOperation(this.verb, this.key, this.value, this.flags, this.index, this.session);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("verb");
            }
            return "Cannot build Operation, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Operation {
        @Nullable
        String verb;
        Optional<String> key = Optional.absent();
        Optional<String> value = Optional.absent();
        Optional<Long> flags = Optional.absent();
        Optional<BigInteger> index = Optional.absent();
        Optional<String> session = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Verb")
        public void setVerb(String verb) {
            this.verb = verb;
        }

        @JsonProperty(value="Key")
        public void setKey(Optional<String> key) {
            this.key = key;
        }

        @JsonProperty(value="Value")
        @JsonSerialize(using=Base64EncodingSerializer.class)
        @JsonDeserialize(using=Base64EncodingDeserializer.class)
        public void setValue(Optional<String> value) {
            this.value = value;
        }

        @JsonProperty(value="Flags")
        public void setFlags(Optional<Long> flags) {
            this.flags = flags;
        }

        @JsonProperty(value="Index")
        public void setIndex(Optional<BigInteger> index) {
            this.index = index;
        }

        @JsonProperty(value="Session")
        public void setSession(Optional<String> session) {
            this.session = session;
        }

        @Override
        public String verb() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> key() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> value() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BigInteger> index() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> session() {
            throw new UnsupportedOperationException();
        }
    }
}

