/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.catalog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.catalog.CatalogService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public final class ImmutableCatalogService
extends CatalogService {
    private final String node;
    private final String address;
    private final Optional<String> datacenter;
    private final String serviceName;
    private final String serviceId;
    private final String serviceAddress;
    private final int servicePort;
    private final ImmutableList<String> serviceTags;
    private final Optional<Map<String, String>> nodeMeta;

    private ImmutableCatalogService(String node, String address, Optional<String> datacenter, String serviceName, String serviceId, String serviceAddress, int servicePort, ImmutableList<String> serviceTags, Optional<Map<String, String>> nodeMeta) {
        this.node = node;
        this.address = address;
        this.datacenter = datacenter;
        this.serviceName = serviceName;
        this.serviceId = serviceId;
        this.serviceAddress = serviceAddress;
        this.servicePort = servicePort;
        this.serviceTags = serviceTags;
        this.nodeMeta = nodeMeta;
    }

    @Override
    @JsonProperty(value="Node")
    public String getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Address")
    public String getAddress() {
        return this.address;
    }

    @Override
    @JsonProperty(value="Datacenter")
    public Optional<String> getDatacenter() {
        return this.datacenter;
    }

    @Override
    @JsonProperty(value="ServiceName")
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    @JsonProperty(value="ServiceID")
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    @JsonProperty(value="ServiceAddress")
    public String getServiceAddress() {
        return this.serviceAddress;
    }

    @Override
    @JsonProperty(value="ServicePort")
    public int getServicePort() {
        return this.servicePort;
    }

    @JsonProperty(value="ServiceTags")
    public ImmutableList<String> getServiceTags() {
        return this.serviceTags;
    }

    @Override
    @JsonProperty(value="NodeMeta")
    public Optional<Map<String, String>> getNodeMeta() {
        return this.nodeMeta;
    }

    public final ImmutableCatalogService withNode(String value) {
        if (this.node.equals(value)) {
            return this;
        }
        return new ImmutableCatalogService((String)Preconditions.checkNotNull((Object)value, (Object)"node"), this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.servicePort, this.serviceTags, this.nodeMeta);
    }

    public final ImmutableCatalogService withAddress(String value) {
        if (this.address.equals(value)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, (String)Preconditions.checkNotNull((Object)value, (Object)"address"), this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.servicePort, this.serviceTags, this.nodeMeta);
    }

    public final ImmutableCatalogService withDatacenter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.datacenter.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, (Optional<String>)newValue, this.serviceName, this.serviceId, this.serviceAddress, this.servicePort, this.serviceTags, this.nodeMeta);
    }

    public final ImmutableCatalogService withDatacenter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"datacenter");
        if (this.datacenter.equals((Object)value)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, (Optional<String>)value, this.serviceName, this.serviceId, this.serviceAddress, this.servicePort, this.serviceTags, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceName(String value) {
        if (this.serviceName.equals(value)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, (String)Preconditions.checkNotNull((Object)value, (Object)"serviceName"), this.serviceId, this.serviceAddress, this.servicePort, this.serviceTags, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceId(String value) {
        if (this.serviceId.equals(value)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, (String)Preconditions.checkNotNull((Object)value, (Object)"serviceId"), this.serviceAddress, this.servicePort, this.serviceTags, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceAddress(String value) {
        if (this.serviceAddress.equals(value)) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, (String)Preconditions.checkNotNull((Object)value, (Object)"serviceAddress"), this.servicePort, this.serviceTags, this.nodeMeta);
    }

    public final ImmutableCatalogService withServicePort(int value) {
        if (this.servicePort == value) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, value, this.serviceTags, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.servicePort, (ImmutableList<String>)newValue, this.nodeMeta);
    }

    public final ImmutableCatalogService withServiceTags(Iterable<String> elements) {
        if (this.serviceTags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.servicePort, (ImmutableList<String>)newValue, this.nodeMeta);
    }

    public final ImmutableCatalogService withNodeMeta(Map<String, String> value) {
        Optional newValue = Optional.of(value);
        if (this.nodeMeta.isPresent() && this.nodeMeta.get() == value) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.servicePort, this.serviceTags, (Optional<Map<String, String>>)newValue);
    }

    public final ImmutableCatalogService withNodeMeta(Optional<Map<String, String>> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"nodeMeta");
        if (!this.nodeMeta.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.nodeMeta.isPresent() && value.isPresent() && this.nodeMeta.get() == value.get()) {
            return this;
        }
        return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.servicePort, this.serviceTags, (Optional<Map<String, String>>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogService && this.equalTo((ImmutableCatalogService)another);
    }

    private boolean equalTo(ImmutableCatalogService another) {
        return this.node.equals(another.node) && this.address.equals(another.address) && this.datacenter.equals(another.datacenter) && this.serviceName.equals(another.serviceName) && this.serviceId.equals(another.serviceId) && this.serviceAddress.equals(another.serviceAddress) && this.servicePort == another.servicePort && this.serviceTags.equals(another.serviceTags) && this.nodeMeta.equals(another.nodeMeta);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.address.hashCode();
        h = h * 17 + this.datacenter.hashCode();
        h = h * 17 + this.serviceName.hashCode();
        h = h * 17 + this.serviceId.hashCode();
        h = h * 17 + this.serviceAddress.hashCode();
        h = h * 17 + this.servicePort;
        h = h * 17 + this.serviceTags.hashCode();
        h = h * 17 + this.nodeMeta.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CatalogService").omitNullValues().add("node", (Object)this.node).add("address", (Object)this.address).add("datacenter", this.datacenter.orNull()).add("serviceName", (Object)this.serviceName).add("serviceId", (Object)this.serviceId).add("serviceAddress", (Object)this.serviceAddress).add("servicePort", this.servicePort).add("serviceTags", this.serviceTags).add("nodeMeta", this.nodeMeta.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableCatalogService fromJson(Json json) {
        Builder builder = ImmutableCatalogService.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.datacenter != null) {
            builder.datacenter(json.datacenter);
        }
        if (json.serviceName != null) {
            builder.serviceName(json.serviceName);
        }
        if (json.serviceId != null) {
            builder.serviceId(json.serviceId);
        }
        if (json.serviceAddress != null) {
            builder.serviceAddress(json.serviceAddress);
        }
        if (json.servicePort != null) {
            builder.servicePort(json.servicePort);
        }
        if (json.serviceTags != null) {
            builder.addAllServiceTags(json.serviceTags);
        }
        if (json.nodeMeta != null) {
            builder.nodeMeta(json.nodeMeta);
        }
        return builder.build();
    }

    public static ImmutableCatalogService copyOf(CatalogService instance) {
        if (instance instanceof ImmutableCatalogService) {
            return (ImmutableCatalogService)instance;
        }
        return ImmutableCatalogService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_ADDRESS = 2L;
        private static final long INIT_BIT_SERVICE_NAME = 4L;
        private static final long INIT_BIT_SERVICE_ID = 8L;
        private static final long INIT_BIT_SERVICE_ADDRESS = 16L;
        private static final long INIT_BIT_SERVICE_PORT = 32L;
        private long initBits = 63L;
        @Nullable
        private String node;
        @Nullable
        private String address;
        private Optional<String> datacenter = Optional.absent();
        @Nullable
        private String serviceName;
        @Nullable
        private String serviceId;
        @Nullable
        private String serviceAddress;
        private int servicePort;
        private ImmutableList.Builder<String> serviceTagsBuilder = ImmutableList.builder();
        private Optional<Map<String, String>> nodeMeta = Optional.absent();

        private Builder() {
        }

        public final Builder from(CatalogService instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.node(instance.getNode());
            this.address(instance.getAddress());
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            this.serviceName(instance.getServiceName());
            this.serviceId(instance.getServiceId());
            this.serviceAddress(instance.getServiceAddress());
            this.servicePort(instance.getServicePort());
            this.addAllServiceTags(instance.getServiceTags());
            Optional<Map<String, String>> nodeMetaOptional = instance.getNodeMeta();
            if (nodeMetaOptional.isPresent()) {
                this.nodeMeta(nodeMetaOptional);
            }
            return this;
        }

        public final Builder node(String node) {
            this.node = (String)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder address(String address) {
            this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = Optional.of((Object)datacenter);
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = (Optional)Preconditions.checkNotNull(datacenter, (Object)"datacenter");
            return this;
        }

        public final Builder serviceName(String serviceName) {
            this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder serviceId(String serviceId) {
            this.serviceId = (String)Preconditions.checkNotNull((Object)serviceId, (Object)"serviceId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder serviceAddress(String serviceAddress) {
            this.serviceAddress = (String)Preconditions.checkNotNull((Object)serviceAddress, (Object)"serviceAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder servicePort(int servicePort) {
            this.servicePort = servicePort;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder addServiceTags(String element) {
            this.serviceTagsBuilder.add((Object)element);
            return this;
        }

        public final Builder addServiceTags(String ... elements) {
            this.serviceTagsBuilder.add((Object[])elements);
            return this;
        }

        public final Builder serviceTags(Iterable<String> elements) {
            this.serviceTagsBuilder = ImmutableList.builder();
            return this.addAllServiceTags(elements);
        }

        public final Builder addAllServiceTags(Iterable<String> elements) {
            this.serviceTagsBuilder.addAll(elements);
            return this;
        }

        public final Builder nodeMeta(Map<String, String> nodeMeta) {
            this.nodeMeta = Optional.of(nodeMeta);
            return this;
        }

        public final Builder nodeMeta(Optional<Map<String, String>> nodeMeta) {
            this.nodeMeta = (Optional)Preconditions.checkNotNull(nodeMeta, (Object)"nodeMeta");
            return this;
        }

        public ImmutableCatalogService build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCatalogService(this.node, this.address, this.datacenter, this.serviceName, this.serviceId, this.serviceAddress, this.servicePort, this.serviceTagsBuilder.build(), this.nodeMeta);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("address");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("serviceName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("serviceId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("serviceAddress");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("servicePort");
            }
            return "Cannot build CatalogService, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends CatalogService {
        @Nullable
        String node;
        @Nullable
        String address;
        Optional<String> datacenter = Optional.absent();
        @Nullable
        String serviceName;
        @Nullable
        String serviceId;
        @Nullable
        String serviceAddress;
        @Nullable
        Integer servicePort;
        List<String> serviceTags = ImmutableList.of();
        Optional<Map<String, String>> nodeMeta = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="Datacenter")
        public void setDatacenter(Optional<String> datacenter) {
            this.datacenter = datacenter;
        }

        @JsonProperty(value="ServiceName")
        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @JsonProperty(value="ServiceID")
        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @JsonProperty(value="ServiceAddress")
        public void setServiceAddress(String serviceAddress) {
            this.serviceAddress = serviceAddress;
        }

        @JsonProperty(value="ServicePort")
        public void setServicePort(int servicePort) {
            this.servicePort = servicePort;
        }

        @JsonProperty(value="ServiceTags")
        public void setServiceTags(List<String> serviceTags) {
            this.serviceTags = serviceTags;
        }

        @JsonProperty(value="NodeMeta")
        public void setNodeMeta(Optional<Map<String, String>> nodeMeta) {
            this.nodeMeta = nodeMeta;
        }

        @Override
        public String getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDatacenter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getServicePort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getServiceTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Map<String, String>> getNodeMeta() {
            throw new UnsupportedOperationException();
        }
    }
}

