/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.query.DnsQuery;
import com.orbitz.consul.model.query.PreparedQuery;
import com.orbitz.consul.model.query.ServiceQuery;
import java.util.ArrayList;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutablePreparedQuery
extends PreparedQuery {
    private final String name;
    private final Optional<String> session;
    private final Optional<String> token;
    private final ServiceQuery service;
    private final Optional<DnsQuery> dns;

    private ImmutablePreparedQuery(String name, Optional<String> session, Optional<String> token, ServiceQuery service, Optional<DnsQuery> dns) {
        this.name = name;
        this.session = session;
        this.token = token;
        this.service = service;
        this.dns = dns;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Session")
    public Optional<String> getSession() {
        return this.session;
    }

    @Override
    @JsonProperty(value="Token")
    public Optional<String> getToken() {
        return this.token;
    }

    @Override
    @JsonProperty(value="Service")
    public ServiceQuery getService() {
        return this.service;
    }

    @Override
    @JsonProperty(value="DNS")
    public Optional<DnsQuery> getDns() {
        return this.dns;
    }

    public final ImmutablePreparedQuery withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        return new ImmutablePreparedQuery((String)Preconditions.checkNotNull((Object)value, (Object)"name"), this.session, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withSession(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.session.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePreparedQuery(this.name, (Optional<String>)newValue, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withSession(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"session");
        if (this.session.equals((Object)value)) {
            return this;
        }
        return new ImmutablePreparedQuery(this.name, (Optional<String>)value, this.token, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withToken(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.token.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePreparedQuery(this.name, this.session, (Optional<String>)newValue, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withToken(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"token");
        if (this.token.equals((Object)value)) {
            return this;
        }
        return new ImmutablePreparedQuery(this.name, this.session, (Optional<String>)value, this.service, this.dns);
    }

    public final ImmutablePreparedQuery withService(ServiceQuery value) {
        if (this.service == value) {
            return this;
        }
        return new ImmutablePreparedQuery(this.name, this.session, this.token, (ServiceQuery)Preconditions.checkNotNull((Object)value, (Object)"service"), this.dns);
    }

    public final ImmutablePreparedQuery withDns(DnsQuery value) {
        Optional newValue = Optional.of((Object)value);
        if (this.dns.isPresent() && this.dns.get() == value) {
            return this;
        }
        return new ImmutablePreparedQuery(this.name, this.session, this.token, this.service, (Optional<DnsQuery>)newValue);
    }

    public final ImmutablePreparedQuery withDns(Optional<DnsQuery> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"dns");
        if (!this.dns.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.dns.isPresent() && value.isPresent() && this.dns.get() == value.get()) {
            return this;
        }
        return new ImmutablePreparedQuery(this.name, this.session, this.token, this.service, (Optional<DnsQuery>)value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePreparedQuery && this.equalTo((ImmutablePreparedQuery)another);
    }

    private boolean equalTo(ImmutablePreparedQuery another) {
        return this.name.equals(another.name) && this.session.equals(another.session) && this.token.equals(another.token) && this.service.equals(another.service) && this.dns.equals(another.dns);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.session.hashCode();
        h = h * 17 + this.token.hashCode();
        h = h * 17 + this.service.hashCode();
        h = h * 17 + this.dns.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PreparedQuery").omitNullValues().add("name", (Object)this.name).add("session", this.session.orNull()).add("token", this.token.orNull()).add("service", (Object)this.service).add("dns", this.dns.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutablePreparedQuery fromJson(Json json) {
        Builder builder = ImmutablePreparedQuery.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.session != null) {
            builder.session(json.session);
        }
        if (json.token != null) {
            builder.token(json.token);
        }
        if (json.service != null) {
            builder.service(json.service);
        }
        if (json.dns != null) {
            builder.dns(json.dns);
        }
        return builder.build();
    }

    public static ImmutablePreparedQuery copyOf(PreparedQuery instance) {
        if (instance instanceof ImmutablePreparedQuery) {
            return (ImmutablePreparedQuery)instance;
        }
        return ImmutablePreparedQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SERVICE = 2L;
        private long initBits = 3L;
        private String name;
        private Optional<String> session = Optional.absent();
        private Optional<String> token = Optional.absent();
        private ServiceQuery service;
        private Optional<DnsQuery> dns = Optional.absent();

        private Builder() {
        }

        public final Builder from(PreparedQuery instance) {
            Optional<String> tokenOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.name(instance.getName());
            Optional<String> sessionOptional = instance.getSession();
            if (sessionOptional.isPresent()) {
                this.session(sessionOptional);
            }
            if ((tokenOptional = instance.getToken()).isPresent()) {
                this.token(tokenOptional);
            }
            this.service(instance.getService());
            Optional<DnsQuery> dnsOptional = instance.getDns();
            if (dnsOptional.isPresent()) {
                this.dns(dnsOptional);
            }
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder session(String session) {
            this.session = Optional.of((Object)session);
            return this;
        }

        public final Builder session(Optional<String> session) {
            this.session = (Optional)Preconditions.checkNotNull(session, (Object)"session");
            return this;
        }

        public final Builder token(String token) {
            this.token = Optional.of((Object)token);
            return this;
        }

        public final Builder token(Optional<String> token) {
            this.token = (Optional)Preconditions.checkNotNull(token, (Object)"token");
            return this;
        }

        public final Builder service(ServiceQuery service) {
            this.service = (ServiceQuery)Preconditions.checkNotNull((Object)service, (Object)"service");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder dns(DnsQuery dns) {
            this.dns = Optional.of((Object)dns);
            return this;
        }

        public final Builder dns(Optional<DnsQuery> dns) {
            this.dns = (Optional)Preconditions.checkNotNull(dns, (Object)"dns");
            return this;
        }

        public ImmutablePreparedQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePreparedQuery(this.name, this.session, this.token, this.service, this.dns);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build PreparedQuery, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends PreparedQuery {
        String name;
        Optional<String> session = Optional.absent();
        Optional<String> token = Optional.absent();
        ServiceQuery service;
        Optional<DnsQuery> dns = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="Session")
        public void setSession(Optional<String> session) {
            this.session = session;
        }

        @JsonProperty(value="Token")
        public void setToken(Optional<String> token) {
            this.token = token;
        }

        @JsonProperty(value="Service")
        public void setService(ServiceQuery service) {
            this.service = service;
        }

        @JsonProperty(value="DNS")
        public void setDns(Optional<DnsQuery> dns) {
            this.dns = dns;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSession() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ServiceQuery getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DnsQuery> getDns() {
            throw new UnsupportedOperationException();
        }
    }
}

