/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.model.health;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orbitz.consul.model.catalog.TaggedAddresses;
import com.orbitz.consul.model.health.Node;
import java.util.ArrayList;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableNode
extends Node {
    private final String node;
    private final String address;
    private final Optional<TaggedAddresses> taggedAddresses;

    private ImmutableNode(String node, String address, Optional<TaggedAddresses> taggedAddresses) {
        this.node = node;
        this.address = address;
        this.taggedAddresses = taggedAddresses;
    }

    @Override
    @JsonProperty(value="Node")
    public String getNode() {
        return this.node;
    }

    @Override
    @JsonProperty(value="Address")
    public String getAddress() {
        return this.address;
    }

    @Override
    @JsonProperty(value="TaggedAddresses")
    public Optional<TaggedAddresses> getTaggedAddresses() {
        return this.taggedAddresses;
    }

    public final ImmutableNode withNode(String value) {
        if (this.node.equals(value)) {
            return this;
        }
        return new ImmutableNode((String)Preconditions.checkNotNull((Object)value, (Object)"node"), this.address, this.taggedAddresses);
    }

    public final ImmutableNode withAddress(String value) {
        if (this.address.equals(value)) {
            return this;
        }
        return new ImmutableNode(this.node, (String)Preconditions.checkNotNull((Object)value, (Object)"address"), this.taggedAddresses);
    }

    public final ImmutableNode withTaggedAddresses(TaggedAddresses value) {
        Optional newValue = Optional.of((Object)value);
        if (this.taggedAddresses.isPresent() && this.taggedAddresses.get() == value) {
            return this;
        }
        return new ImmutableNode(this.node, this.address, (Optional<TaggedAddresses>)newValue);
    }

    public final ImmutableNode withTaggedAddresses(Optional<TaggedAddresses> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"taggedAddresses");
        if (!this.taggedAddresses.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.taggedAddresses.isPresent() && value.isPresent() && this.taggedAddresses.get() == value.get()) {
            return this;
        }
        return new ImmutableNode(this.node, this.address, (Optional<TaggedAddresses>)value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNode && this.equalTo((ImmutableNode)another);
    }

    private boolean equalTo(ImmutableNode another) {
        return this.node.equals(another.node) && this.address.equals(another.address) && this.taggedAddresses.equals(another.taggedAddresses);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.node.hashCode();
        h = h * 17 + this.address.hashCode();
        h = h * 17 + this.taggedAddresses.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Node").omitNullValues().add("node", (Object)this.node).add("address", (Object)this.address).add("taggedAddresses", this.taggedAddresses.orNull()).toString();
    }

    @Deprecated
    @JsonCreator
    static ImmutableNode fromJson(Json json) {
        Builder builder = ImmutableNode.builder();
        if (json.node != null) {
            builder.node(json.node);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.taggedAddresses != null) {
            builder.taggedAddresses(json.taggedAddresses);
        }
        return builder.build();
    }

    public static ImmutableNode copyOf(Node instance) {
        if (instance instanceof ImmutableNode) {
            return (ImmutableNode)instance;
        }
        return ImmutableNode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_ADDRESS = 2L;
        private long initBits = 3L;
        private String node;
        private String address;
        private Optional<TaggedAddresses> taggedAddresses = Optional.absent();

        private Builder() {
        }

        public final Builder from(Node instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.node(instance.getNode());
            this.address(instance.getAddress());
            Optional<TaggedAddresses> taggedAddressesOptional = instance.getTaggedAddresses();
            if (taggedAddressesOptional.isPresent()) {
                this.taggedAddresses(taggedAddressesOptional);
            }
            return this;
        }

        public final Builder node(String node) {
            this.node = (String)Preconditions.checkNotNull((Object)node, (Object)"node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder address(String address) {
            this.address = (String)Preconditions.checkNotNull((Object)address, (Object)"address");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder taggedAddresses(TaggedAddresses taggedAddresses) {
            this.taggedAddresses = Optional.of((Object)taggedAddresses);
            return this;
        }

        public final Builder taggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = (Optional)Preconditions.checkNotNull(taggedAddresses, (Object)"taggedAddresses");
            return this;
        }

        public ImmutableNode build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNode(this.node, this.address, this.taggedAddresses);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("address");
            }
            return "Cannot build Node, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    static final class Json
    extends Node {
        String node;
        String address;
        Optional<TaggedAddresses> taggedAddresses = Optional.absent();

        Json() {
        }

        @JsonProperty(value="Node")
        public void setNode(String node) {
            this.node = node;
        }

        @JsonProperty(value="Address")
        public void setAddress(String address) {
            this.address = address;
        }

        @JsonProperty(value="TaggedAddresses")
        public void setTaggedAddresses(Optional<TaggedAddresses> taggedAddresses) {
            this.taggedAddresses = taggedAddresses;
        }

        @Override
        public String getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TaggedAddresses> getTaggedAddresses() {
            throw new UnsupportedOperationException();
        }
    }
}

