/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.orbitz.consul.model.acl.AclResponse;
import com.orbitz.consul.model.acl.AclToken;
import com.orbitz.consul.model.acl.AclTokenId;
import com.orbitz.consul.util.Http;
import java.util.List;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.PUT;
import retrofit2.http.Path;

public class AclClient {
    private final Api api;

    AclClient(Retrofit retrofit) {
        this.api = (Api)retrofit.create(Api.class);
    }

    public String createAcl(AclToken aclToken) {
        return Http.extract(this.api.createAcl(aclToken)).id();
    }

    public void updateAcl(AclToken aclToken) {
        Http.handle(this.api.updateAcl(aclToken));
    }

    public void destroyAcl(String id) {
        Http.handle(this.api.destroyAcl(id));
    }

    public AclResponse getAclInfo(String id) {
        return Http.extract(this.api.getAclInfo(id));
    }

    public String cloneAcl(String id) {
        return Http.extract(this.api.cloneAcl(id)).id();
    }

    public List<AclResponse> listAcls() {
        return Http.extract(this.api.listAcls());
    }

    private static interface Api {
        @PUT(value="acl/create")
        public Call<AclTokenId> createAcl(@Body AclToken var1);

        @PUT(value="acl/update")
        public Call<Void> updateAcl(@Body AclToken var1);

        @PUT(value="acl/destroy/{id}")
        public Call<Void> destroyAcl(@Path(value="id") String var1);

        @GET(value="acl/info/{id}")
        public Call<AclResponse> getAclInfo(@Path(value="id") String var1);

        @PUT(value="acl/clone/{id}")
        public Call<AclTokenId> cloneAcl(@Path(value="id") String var1);

        @GET(value="acl/list")
        public Call<List<AclResponse>> listAcls();
    }
}

