/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.orbitz.consul.option.CatalogOptions;

public final class ImmutableCatalogOptions
extends CatalogOptions {
    private final Optional<String> datacenter;
    private final Optional<String> tag;

    private ImmutableCatalogOptions(Optional<String> datacenter, Optional<String> tag) {
        this.datacenter = datacenter;
        this.tag = tag;
    }

    @Override
    public Optional<String> getDatacenter() {
        return this.datacenter;
    }

    @Override
    public Optional<String> getTag() {
        return this.tag;
    }

    public final ImmutableCatalogOptions withDatacenter(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.datacenter.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCatalogOptions((Optional<String>)newValue, this.tag);
    }

    public final ImmutableCatalogOptions withDatacenter(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"datacenter");
        if (this.datacenter.equals((Object)value)) {
            return this;
        }
        return new ImmutableCatalogOptions((Optional<String>)value, this.tag);
    }

    public final ImmutableCatalogOptions withTag(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.tag.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCatalogOptions(this.datacenter, (Optional<String>)newValue);
    }

    public final ImmutableCatalogOptions withTag(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"tag");
        if (this.tag.equals((Object)value)) {
            return this;
        }
        return new ImmutableCatalogOptions(this.datacenter, (Optional<String>)value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCatalogOptions && this.equalTo((ImmutableCatalogOptions)another);
    }

    private boolean equalTo(ImmutableCatalogOptions another) {
        return this.datacenter.equals(another.datacenter) && this.tag.equals(another.tag);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.datacenter.hashCode();
        h = h * 17 + this.tag.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CatalogOptions").omitNullValues().add("datacenter", this.datacenter.orNull()).add("tag", this.tag.orNull()).toString();
    }

    public static ImmutableCatalogOptions copyOf(CatalogOptions instance) {
        if (instance instanceof ImmutableCatalogOptions) {
            return (ImmutableCatalogOptions)instance;
        }
        return ImmutableCatalogOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Optional<String> datacenter = Optional.absent();
        private Optional<String> tag = Optional.absent();

        private Builder() {
        }

        public final Builder from(CatalogOptions instance) {
            Optional<String> tagOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> datacenterOptional = instance.getDatacenter();
            if (datacenterOptional.isPresent()) {
                this.datacenter(datacenterOptional);
            }
            if ((tagOptional = instance.getTag()).isPresent()) {
                this.tag(tagOptional);
            }
            return this;
        }

        public final Builder datacenter(String datacenter) {
            this.datacenter = Optional.of((Object)datacenter);
            return this;
        }

        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = (Optional)Preconditions.checkNotNull(datacenter, (Object)"datacenter");
            return this;
        }

        public final Builder tag(String tag) {
            this.tag = Optional.of((Object)tag);
            return this;
        }

        public final Builder tag(Optional<String> tag) {
            this.tag = (Optional)Preconditions.checkNotNull(tag, (Object)"tag");
            return this;
        }

        public ImmutableCatalogOptions build() {
            return new ImmutableCatalogOptions(this.datacenter, this.tag);
        }
    }
}

