/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.consul;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.net.HostAndPort;
import com.orbitz.consul.AgentClient;
import com.orbitz.consul.CatalogClient;
import com.orbitz.consul.EventClient;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.PreparedQueryClient;
import com.orbitz.consul.SessionClient;
import com.orbitz.consul.StatusClient;
import com.orbitz.consul.util.Jackson;
import com.orbitz.fasterxml.jackson.databind.ObjectMapper;
import com.orbitz.okhttp3.HttpUrl;
import com.orbitz.okhttp3.Interceptor;
import com.orbitz.okhttp3.OkHttpClient;
import com.orbitz.okhttp3.Request;
import com.orbitz.okhttp3.Response;
import com.orbitz.retrofit.Retrofit;
import com.orbitz.retrofit.converter.jackson.JacksonConverterFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;

public class Consul {
    public static final String DEFAULT_HTTP_HOST = "localhost";
    public static final int DEFAULT_HTTP_PORT = 8500;
    private final AgentClient agentClient;
    private final HealthClient healthClient;
    private final KeyValueClient keyValueClient;
    private final CatalogClient catalogClient;
    private final StatusClient statusClient;
    private final SessionClient sessionClient;
    private final EventClient eventClient;
    private final PreparedQueryClient preparedQueryClient;

    private Consul(AgentClient agentClient, HealthClient healthClient, KeyValueClient keyValueClient, CatalogClient catalogClient, StatusClient statusClient, SessionClient sessionClient, EventClient eventClient, PreparedQueryClient preparedQueryClient) {
        this.agentClient = agentClient;
        this.healthClient = healthClient;
        this.keyValueClient = keyValueClient;
        this.catalogClient = catalogClient;
        this.statusClient = statusClient;
        this.sessionClient = sessionClient;
        this.eventClient = eventClient;
        this.preparedQueryClient = preparedQueryClient;
    }

    public AgentClient agentClient() {
        return this.agentClient;
    }

    public CatalogClient catalogClient() {
        return this.catalogClient;
    }

    public HealthClient healthClient() {
        return this.healthClient;
    }

    public KeyValueClient keyValueClient() {
        return this.keyValueClient;
    }

    public StatusClient statusClient() {
        return this.statusClient;
    }

    public SessionClient sessionClient() {
        return this.sessionClient;
    }

    public EventClient eventClient() {
        return this.eventClient;
    }

    public PreparedQueryClient preparedQueryClient() {
        return this.preparedQueryClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    public static Consul newClient() {
        return Consul.builder().build();
    }

    public static class Builder {
        private URL url;
        private SSLContext sslContext;
        private boolean ping = true;
        private Interceptor basicAuthInterceptor;
        private Interceptor aclTokenInterceptor;
        private Long connectTimeoutMillis;
        private Long readTimeoutMillis;
        private Long writeTimeoutMillis;

        Builder() {
            try {
                this.url = new URL("http", Consul.DEFAULT_HTTP_HOST, 8500, "");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }

        public Builder withUrl(URL url) {
            this.url = url;
            return this;
        }

        public Builder withPing(boolean ping) {
            this.ping = ping;
            return this;
        }

        public Builder withBasicAuth(String username, String password) {
            String credentials = username + ":" + password;
            final String basic = "Basic " + BaseEncoding.base64().encode(credentials.getBytes());
            this.basicAuthInterceptor = new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Request original = chain.request();
                    Request.Builder requestBuilder = original.newBuilder().header("Authorization", basic).method(original.method(), original.body());
                    Request request = requestBuilder.build();
                    return chain.proceed(request);
                }
            };
            return this;
        }

        public Builder withAclToken(final String token) {
            this.aclTokenInterceptor = new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Request original = chain.request();
                    HttpUrl originalUrl = original.url();
                    String rewrittenUrl = originalUrl.queryParameterNames().isEmpty() ? originalUrl.url().toExternalForm() + "?token=" + token : originalUrl.url().toExternalForm() + "&token=" + token;
                    Request.Builder requestBuilder = original.newBuilder().url(rewrittenUrl).method(original.method(), original.body());
                    Request request = requestBuilder.build();
                    return chain.proceed(request);
                }
            };
            return this;
        }

        public Builder withHostAndPort(HostAndPort hostAndPort) {
            try {
                this.url = new URL("http", hostAndPort.getHostText(), hostAndPort.getPort(), "");
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withUrl(String url) {
            try {
                this.url = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder withSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder withConnectTimeoutMillis(long timeoutMillis) {
            Preconditions.checkArgument((timeoutMillis >= 0L ? 1 : 0) != 0, (Object)"Negative value");
            this.connectTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder withReadTimeoutMillis(long timeoutMillis) {
            Preconditions.checkArgument((timeoutMillis >= 0L ? 1 : 0) != 0, (Object)"Negative value");
            this.readTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder withWriteTimeoutMillis(long timeoutMillis) {
            Preconditions.checkArgument((timeoutMillis >= 0L ? 1 : 0) != 0, (Object)"Negative value");
            this.writeTimeoutMillis = timeoutMillis;
            return this;
        }

        public Consul build() {
            Retrofit retrofit;
            try {
                retrofit = this.createRetrofit(this.url.toExternalForm(), this.sslContext, Jackson.MAPPER);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            AgentClient agentClient = new AgentClient(retrofit);
            HealthClient healthClient = new HealthClient(retrofit);
            KeyValueClient keyValueClient = new KeyValueClient(retrofit);
            CatalogClient catalogClient = new CatalogClient(retrofit);
            StatusClient statusClient = new StatusClient(retrofit);
            SessionClient sessionClient = new SessionClient(retrofit);
            EventClient eventClient = new EventClient(retrofit);
            PreparedQueryClient preparedQueryClient = new PreparedQueryClient(retrofit);
            if (this.ping) {
                agentClient.ping();
            }
            return new Consul(agentClient, healthClient, keyValueClient, catalogClient, statusClient, sessionClient, eventClient, preparedQueryClient);
        }

        private Retrofit createRetrofit(String url, SSLContext sslContext, ObjectMapper mapper) throws MalformedURLException {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            if (this.basicAuthInterceptor != null) {
                builder.addInterceptor(this.basicAuthInterceptor);
            }
            if (this.aclTokenInterceptor != null) {
                builder.addInterceptor(this.aclTokenInterceptor);
            }
            if (sslContext != null) {
                builder.sslSocketFactory(sslContext.getSocketFactory());
            }
            if (this.connectTimeoutMillis != null) {
                builder.connectTimeout(this.connectTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            if (this.readTimeoutMillis != null) {
                builder.readTimeout(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            if (this.writeTimeoutMillis != null) {
                builder.writeTimeout(this.writeTimeoutMillis, TimeUnit.MILLISECONDS);
            }
            URL consulUrl = new URL(url);
            return new Retrofit.Builder().baseUrl(new URL(consulUrl.getProtocol(), consulUrl.getHost(), consulUrl.getPort(), "/v1/").toExternalForm()).addConverterFactory(JacksonConverterFactory.create(mapper)).client(builder.build()).build();
        }
    }
}

