/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.retrofit;

import com.orbitz.okhttp3.Headers;
import com.orbitz.okhttp3.Protocol;
import com.orbitz.okhttp3.Request;
import com.orbitz.okhttp3.Response;
import com.orbitz.okhttp3.ResponseBody;

public final class Response<T> {
    private final com.orbitz.okhttp3.Response rawResponse;
    private final T body;
    private final ResponseBody errorBody;

    public static <T> Response<T> success(T body) {
        return Response.success(body, new Response.Builder().code(200).message("OK").protocol(Protocol.HTTP_1_1).request(new Request.Builder().url("http://localhost/").build()).build());
    }

    public static <T> Response<T> success(T body, Headers headers) {
        if (headers == null) {
            throw new NullPointerException("headers == null");
        }
        return Response.success(body, new Response.Builder().code(200).message("OK").protocol(Protocol.HTTP_1_1).headers(headers).request(new Request.Builder().url("http://localhost/").build()).build());
    }

    public static <T> Response<T> success(T body, com.orbitz.okhttp3.Response rawResponse) {
        if (rawResponse == null) {
            throw new NullPointerException("rawResponse == null");
        }
        if (!rawResponse.isSuccessful()) {
            throw new IllegalArgumentException("rawResponse must be successful response");
        }
        return new Response<T>(rawResponse, body, null);
    }

    public static <T> Response<T> error(int code, ResponseBody body) {
        if (code < 400) {
            throw new IllegalArgumentException("code < 400: " + code);
        }
        return Response.error(body, new Response.Builder().code(code).protocol(Protocol.HTTP_1_1).request(new Request.Builder().url("http://localhost/").build()).build());
    }

    public static <T> Response<T> error(ResponseBody body, com.orbitz.okhttp3.Response rawResponse) {
        if (body == null) {
            throw new NullPointerException("body == null");
        }
        if (rawResponse == null) {
            throw new NullPointerException("rawResponse == null");
        }
        if (rawResponse.isSuccessful()) {
            throw new IllegalArgumentException("rawResponse should not be successful response");
        }
        return new Response<Object>(rawResponse, null, body);
    }

    private Response(com.orbitz.okhttp3.Response rawResponse, T body, ResponseBody errorBody) {
        this.rawResponse = rawResponse;
        this.body = body;
        this.errorBody = errorBody;
    }

    public com.orbitz.okhttp3.Response raw() {
        return this.rawResponse;
    }

    public int code() {
        return this.rawResponse.code();
    }

    public String message() {
        return this.rawResponse.message();
    }

    public Headers headers() {
        return this.rawResponse.headers();
    }

    public boolean isSuccessful() {
        return this.rawResponse.isSuccessful();
    }

    public T body() {
        return this.body;
    }

    public ResponseBody errorBody() {
        return this.errorBody;
    }
}

