/*
 * Decompiled with CFR 0.152.
 */
package com.orbitz.fasterxml.jackson.datatype.guava.deser;

import com.google.common.base.Optional;
import com.orbitz.fasterxml.jackson.core.JsonParser;
import com.orbitz.fasterxml.jackson.core.JsonToken;
import com.orbitz.fasterxml.jackson.databind.AnnotationIntrospector;
import com.orbitz.fasterxml.jackson.databind.BeanProperty;
import com.orbitz.fasterxml.jackson.databind.DeserializationContext;
import com.orbitz.fasterxml.jackson.databind.JavaType;
import com.orbitz.fasterxml.jackson.databind.JsonDeserializer;
import com.orbitz.fasterxml.jackson.databind.JsonMappingException;
import com.orbitz.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.orbitz.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.orbitz.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.orbitz.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.orbitz.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;

public class GuavaOptionalDeserializer
extends StdDeserializer<Optional<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _fullType;
    protected final JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public GuavaOptionalDeserializer(JavaType fullType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        super(fullType);
        this._fullType = fullType;
        this._valueTypeDeserializer = typeDeser;
        this._valueDeserializer = valueDeser;
    }

    @Override
    public JavaType getValueType() {
        return this._fullType;
    }

    @Override
    public Optional<?> getNullValue(DeserializationContext ctxt) {
        return Optional.absent();
    }

    @Override
    @Deprecated
    public Optional<?> getNullValue() {
        return Optional.absent();
    }

    protected GuavaOptionalDeserializer withResolved(JavaType fullType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        if (this._fullType == fullType && valueDeser == this._valueDeserializer && typeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return new GuavaOptionalDeserializer(this._fullType, typeDeser, valueDeser);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        JavaType fullType = this._fullType;
        if (deser == null) {
            JavaType refdType;
            if (property != null) {
                AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
                AnnotatedMember member = property.getMember();
                if (intr != null && member != null) {
                    fullType = intr.refineDeserializationType(ctxt.getConfig(), member, fullType);
                }
            }
            if ((refdType = fullType.getContentType()) == null) {
                refdType = TypeFactory.unknownType();
            }
            deser = ctxt.findContextualValueDeserializer(refdType, property);
        } else {
            JavaType refdType = fullType.getContentType();
            if (refdType == null) {
                refdType = TypeFactory.unknownType();
            }
            deser = ctxt.handleSecondaryContextualization(deser, property, refdType);
        }
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property);
        }
        return this.withResolved(fullType, typeDeser, deser);
    }

    @Override
    public Optional<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object refd = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(p, ctxt) : this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        return Optional.fromNullable(refd);
    }

    public Optional<?> deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return this.getNullValue(ctxt);
        }
        if (t != null && t.isScalarValue()) {
            return this.deserialize(p, ctxt);
        }
        return (Optional)typeDeserializer.deserializeTypedFromAny(p, ctxt);
    }
}

