package com.orbitz.consul.model.health;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link HealthCheck}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHealthCheck.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "HealthCheck"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableHealthCheck extends HealthCheck {
  private final String node;
  private final String checkId;
  private final String name;
  private final String status;
  private final Optional<String> notes;
  private final Optional<String> output;
  private final Optional<String> serviceId;
  private final Optional<String> serviceName;

  private ImmutableHealthCheck(
      String node,
      String checkId,
      String name,
      String status,
      Optional<String> notes,
      Optional<String> output,
      Optional<String> serviceId,
      Optional<String> serviceName) {
    this.node = node;
    this.checkId = checkId;
    this.name = name;
    this.status = status;
    this.notes = notes;
    this.output = output;
    this.serviceId = serviceId;
    this.serviceName = serviceName;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty(value = "Node")
  @Override
  public String getNode() {
    return node;
  }

  /**
   * @return The value of the {@code checkId} attribute
   */
  @JsonProperty(value = "CheckID")
  @Override
  public String getCheckId() {
    return checkId;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty(value = "Name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty(value = "Status")
  @Override
  public String getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code notes} attribute
   */
  @JsonProperty(value = "Notes")
  @Override
  public Optional<String> getNotes() {
    return notes;
  }

  /**
   * @return The value of the {@code output} attribute
   */
  @JsonProperty(value = "Output")
  @Override
  public Optional<String> getOutput() {
    return output;
  }

  /**
   * @return The value of the {@code serviceId} attribute
   */
  @JsonProperty(value = "ServiceID")
  @Override
  public Optional<String> getServiceId() {
    return serviceId;
  }

  /**
   * @return The value of the {@code serviceName} attribute
   */
  @JsonProperty(value = "ServiceName")
  @Override
  public Optional<String> getServiceName() {
    return serviceName;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HealthCheck#getNode() node} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHealthCheck withNode(String value) {
    if (this.node.equals(value)) return this;
    return new ImmutableHealthCheck(
        Preconditions.checkNotNull(value, "node"),
        this.checkId,
        this.name,
        this.status,
        this.notes,
        this.output,
        this.serviceId,
        this.serviceName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HealthCheck#getCheckId() checkId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for checkId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHealthCheck withCheckId(String value) {
    if (this.checkId.equals(value)) return this;
    return new ImmutableHealthCheck(
        this.node,
        Preconditions.checkNotNull(value, "checkId"),
        this.name,
        this.status,
        this.notes,
        this.output,
        this.serviceId,
        this.serviceName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HealthCheck#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHealthCheck withName(String value) {
    if (this.name.equals(value)) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        Preconditions.checkNotNull(value, "name"),
        this.status,
        this.notes,
        this.output,
        this.serviceId,
        this.serviceName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HealthCheck#getStatus() status} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHealthCheck withStatus(String value) {
    if (this.status.equals(value)) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        Preconditions.checkNotNull(value, "status"),
        this.notes,
        this.output,
        this.serviceId,
        this.serviceName);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HealthCheck#getNotes() notes} attribute.
   * @param value The value for notes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withNotes(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        newValue,
        this.output,
        this.serviceId,
        this.serviceName);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HealthCheck#getNotes() notes} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for notes
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withNotes(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "notes");
    if (this.notes == value) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        value,
        this.output,
        this.serviceId,
        this.serviceName);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HealthCheck#getOutput() output} attribute.
   * @param value The value for output
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withOutput(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        newValue,
        this.serviceId,
        this.serviceName);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HealthCheck#getOutput() output} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for output
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withOutput(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "output");
    if (this.output == value) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        value,
        this.serviceId,
        this.serviceName);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HealthCheck#getServiceId() serviceId} attribute.
   * @param value The value for serviceId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withServiceId(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        this.output,
        newValue,
        this.serviceName);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HealthCheck#getServiceId() serviceId} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withServiceId(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "serviceId");
    if (this.serviceId == value) return this;
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        this.output,
        value,
        this.serviceName);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link HealthCheck#getServiceName() serviceName} attribute.
   * @param value The value for serviceName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withServiceName(String value) {
    Optional<String> newValue = Optional.of(value);
    return new ImmutableHealthCheck(
        this.node,
        this.checkId,
        this.name,
        this.status,
        this.notes,
        this.output,
        this.serviceId,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link HealthCheck#getServiceName() serviceName} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for serviceName
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHealthCheck withServiceName(Optional<String> optional) {
    Optional<String> value = Preconditions.checkNotNull(optional, "serviceName");
    if (this.serviceName == value) return this;
    return new ImmutableHealthCheck(this.node, this.checkId, this.name, this.status, this.notes, this.output, this.serviceId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHealthCheck} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHealthCheck
        && equalTo((ImmutableHealthCheck) another);
  }

  private boolean equalTo(ImmutableHealthCheck another) {
    return node.equals(another.node)
        && checkId.equals(another.checkId)
        && name.equals(another.name)
        && status.equals(another.status)
        && notes.equals(another.notes)
        && output.equals(another.output)
        && serviceId.equals(another.serviceId)
        && serviceName.equals(another.serviceName);
  }

  /**
   * Computes a hash code from attributes: {@code node}, {@code checkId}, {@code name}, {@code status}, {@code notes}, {@code output}, {@code serviceId}, {@code serviceName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + node.hashCode();
    h = h * 17 + checkId.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + status.hashCode();
    h = h * 17 + notes.hashCode();
    h = h * 17 + output.hashCode();
    h = h * 17 + serviceId.hashCode();
    h = h * 17 + serviceName.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HealthCheck...} with all non-generated
   * and non-auxiliary attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("HealthCheck")
        .add("node", node)
        .add("checkId", checkId)
        .add("name", name)
        .add("status", status)
        .add("notes", notes)
        .add("output", output)
        .add("serviceId", serviceId)
        .add("serviceName", serviceName)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  static final class Json extends HealthCheck {
    String node;
    String checkId;
    String name;
    String status;
    Optional<String> notes = Optional.absent();
    Optional<String> output = Optional.absent();
    Optional<String> serviceId = Optional.absent();
    Optional<String> serviceName = Optional.absent();
    @JsonProperty(value = "Node")
    public void setNode(String node) {
      this.node = node;
    }
    @JsonProperty(value = "CheckID")
    public void setCheckId(String checkId) {
      this.checkId = checkId;
    }
    @JsonProperty(value = "Name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty(value = "Status")
    public void setStatus(String status) {
      this.status = status;
    }
    @JsonProperty(value = "Notes")
    public void setNotes(Optional<String> notes) {
      this.notes = notes;
    }
    @JsonProperty(value = "Output")
    public void setOutput(Optional<String> output) {
      this.output = output;
    }
    @JsonProperty(value = "ServiceID")
    public void setServiceId(Optional<String> serviceId) {
      this.serviceId = serviceId;
    }
    @JsonProperty(value = "ServiceName")
    public void setServiceName(Optional<String> serviceName) {
      this.serviceName = serviceName;
    }
    @Override
    public String getNode() { throw new UnsupportedOperationException(); }
    @Override
    public String getCheckId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getStatus() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getNotes() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getOutput() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getServiceId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getServiceName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableHealthCheck fromJson(Json json) {
    ImmutableHealthCheck.Builder builder = ImmutableHealthCheck.builder();
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.checkId != null) {
      builder.checkId(json.checkId);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.notes != null) {
      builder.notes(json.notes);
    }
    if (json.output != null) {
      builder.output(json.output);
    }
    if (json.serviceId != null) {
      builder.serviceId(json.serviceId);
    }
    if (json.serviceName != null) {
      builder.serviceName(json.serviceName);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link HealthCheck} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HealthCheck instance
   */
  public static ImmutableHealthCheck copyOf(HealthCheck instance) {
    if (instance instanceof ImmutableHealthCheck) {
      return (ImmutableHealthCheck) instance;
    }
    return ImmutableHealthCheck.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHealthCheck ImmutableHealthCheck}.
   * @return A new ImmutableHealthCheck builder
   */
  public static ImmutableHealthCheck.Builder builder() {
    return new ImmutableHealthCheck.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHealthCheck ImmutableHealthCheck}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NODE = 0x1L;
    private static final long INIT_BIT_CHECK_ID = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_STATUS = 0x8L;
    private long initBits = 0xf;

    private String node;
    private String checkId;
    private String name;
    private String status;
    private Optional<String> notes = Optional.absent();
    private Optional<String> output = Optional.absent();
    private Optional<String> serviceId = Optional.absent();
    private Optional<String> serviceName = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HealthCheck} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HealthCheck instance) {
      Preconditions.checkNotNull(instance, "instance");
      node(instance.getNode());
      checkId(instance.getCheckId());
      name(instance.getName());
      status(instance.getStatus());
      Optional<String> notesOptional = instance.getNotes();
      if (notesOptional.isPresent()) {
        notes(notesOptional);
      }
      Optional<String> outputOptional = instance.getOutput();
      if (outputOptional.isPresent()) {
        output(outputOptional);
      }
      Optional<String> serviceIdOptional = instance.getServiceId();
      if (serviceIdOptional.isPresent()) {
        serviceId(serviceIdOptional);
      }
      Optional<String> serviceNameOptional = instance.getServiceName();
      if (serviceNameOptional.isPresent()) {
        serviceName(serviceNameOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link HealthCheck#getNode() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder node(String node) {
      this.node = Preconditions.checkNotNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Initializes the value for the {@link HealthCheck#getCheckId() checkId} attribute.
     * @param checkId The value for checkId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder checkId(String checkId) {
      this.checkId = Preconditions.checkNotNull(checkId, "checkId");
      initBits &= ~INIT_BIT_CHECK_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link HealthCheck#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link HealthCheck#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder status(String status) {
      this.status = Preconditions.checkNotNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getNotes() notes} to notes.
     * @param notes The value for notes
     * @return {@code this} builder for chained invocation
     */
    public final Builder notes(String notes) {
      this.notes = Optional.of(notes);
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getNotes() notes} to notes.
     * @param notes The value for notes
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder notes(Optional<String> notes) {
      this.notes = Preconditions.checkNotNull(notes, "notes");
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getOutput() output} to output.
     * @param output The value for output
     * @return {@code this} builder for chained invocation
     */
    public final Builder output(String output) {
      this.output = Optional.of(output);
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getOutput() output} to output.
     * @param output The value for output
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder output(Optional<String> output) {
      this.output = Preconditions.checkNotNull(output, "output");
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getServiceId() serviceId} to serviceId.
     * @param serviceId The value for serviceId
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceId(String serviceId) {
      this.serviceId = Optional.of(serviceId);
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getServiceId() serviceId} to serviceId.
     * @param serviceId The value for serviceId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceId(Optional<String> serviceId) {
      this.serviceId = Preconditions.checkNotNull(serviceId, "serviceId");
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getServiceName() serviceName} to serviceName.
     * @param serviceName The value for serviceName
     * @return {@code this} builder for chained invocation
     */
    public final Builder serviceName(String serviceName) {
      this.serviceName = Optional.of(serviceName);
      return this;
    }

    /**
     * Initializes the optional value {@link HealthCheck#getServiceName() serviceName} to serviceName.
     * @param serviceName The value for serviceName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder serviceName(Optional<String> serviceName) {
      this.serviceName = Preconditions.checkNotNull(serviceName, "serviceName");
      return this;
    }

    /**
     * Builds a new {@link ImmutableHealthCheck ImmutableHealthCheck}.
     * @return An immutable instance of HealthCheck
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHealthCheck build() throws IllegalStateException {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHealthCheck(node, checkId, name, status, notes, output, serviceId, serviceName);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = Lists.newArrayList();
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      if ((initBits & INIT_BIT_CHECK_ID) != 0) attributes.add("checkId");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build HealthCheck, some of required attributes are not set " + attributes;
    }
  }
}
