/*
 * Decompiled with CFR 0.152.
 */
package redis.netty4;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.netty4.AbstractRedisDecoderState;
import redis.netty4.IRedisDecoderState;
import redis.netty4.InitialRedisDecoderState;
import redis.netty4.MultiBulkReply;
import redis.netty4.Reply;

public class InAMultiBulkDecoderState
extends AbstractRedisDecoderState
implements IRedisDecoderState {
    private static final Logger LOG = LoggerFactory.getLogger(InAMultiBulkDecoderState.class);
    private final MultiBulkReply reply;
    private IRedisDecoderState subState = new InitialRedisDecoderState();

    public InAMultiBulkDecoderState(int size) {
        this.reply = new MultiBulkReply(size);
    }

    @Override
    public void decode(ByteBuf in) throws IOException {
        if (this.reply.isFull()) {
            this.setDecodedReply(this.reply);
            this.setNextState(new InitialRedisDecoderState());
        } else {
            Reply dr;
            do {
                this.subState.decode(in);
                dr = this.subState.getDecodedReply();
                this.subState = this.subState.getNextState();
                if (dr == null) continue;
                LOG.trace("*addReply {}", (Object)dr);
                this.reply.add(dr);
            } while (dr != null && !this.reply.isFull());
            if (this.reply.isFull()) {
                this.setNextState(new InitialRedisDecoderState());
                this.setDecodedReply(this.reply);
            } else {
                this.setNextState(this);
                this.setDecodedReply(null);
            }
        }
    }
}

