/*
 * Decompiled with CFR 0.152.
 */
package redis.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.io.IOException;
import java.util.List;
import redis.netty4.AbstractRedisDecoderState;
import redis.netty4.Command;
import redis.server.netty.RedisException;

public class RedisCommandDecoder
extends ReplayingDecoder<Void> {
    private byte[][] bytes;
    private int arguments = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (this.bytes != null) {
            int numArgs = this.bytes.length;
            for (int i = this.arguments; i < numArgs; ++i) {
                if (in.readByte() == 36) {
                    long l = AbstractRedisDecoderState.readLong(in);
                    if (l > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
                    }
                    int size = (int)l;
                    this.bytes[i] = new byte[size];
                    in.readBytes(this.bytes[i]);
                    if (in.bytesBefore((byte)13) != 0) {
                        throw new RedisException("Argument doesn't end in CRLF");
                    }
                    in.skipBytes(2);
                    ++this.arguments;
                } else {
                    throw new IOException("Unexpected character");
                }
                this.checkpoint();
            }
            try {
                out.add(new Command((Object[])this.bytes));
            }
            finally {
                this.bytes = null;
                this.arguments = 0;
            }
        } else if (in.readByte() == 42) {
            long l = AbstractRedisDecoderState.readLong(in);
            if (l > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Java only supports arrays up to 2147483647 in size");
            }
            int numArgs = (int)l;
            if (numArgs < 0) {
                throw new RedisException("Invalid size: " + numArgs);
            }
            this.bytes = new byte[numArgs][];
            this.checkpoint();
            this.decode(ctx, in, out);
        } else {
            in.readerIndex(in.readerIndex() - 1);
            byte[][] b = new byte[][]{in.readBytes(in.bytesBefore((byte)13)).array()};
            in.skipBytes(2);
            out.add(new Command((Object[])b, true));
        }
    }
}

