/*
 * Decompiled with CFR 0.152.
 */
package redis.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import redis.netty4.AbstarctReply;
import redis.util.Encoding;

public class InlineReply
extends AbstarctReply<Object> {
    public InlineReply(Object o) {
        super(o);
    }

    @Override
    public void write(ByteBuf os) throws IOException {
        Object o = this.data();
        if (o == null) {
            os.writeBytes(CRLF);
        } else if (o instanceof String) {
            os.writeByte(43);
            os.writeBytes(((String)o).getBytes(CharsetUtil.US_ASCII));
            os.writeBytes(CRLF);
        } else if (o instanceof ByteBuf) {
            os.writeByte(43);
            os.writeBytes(((ByteBuf)o).array());
            os.writeBytes(CRLF);
        } else if (o instanceof byte[]) {
            os.writeByte(43);
            os.writeBytes((byte[])o);
            os.writeBytes(CRLF);
        } else if (o instanceof Long) {
            os.writeByte(58);
            os.writeBytes(Encoding.numToBytes((Long)o, true));
        } else {
            os.writeBytes("ERR invalid inline response".getBytes(CharsetUtil.US_ASCII));
            os.writeBytes(CRLF);
        }
    }

    @Override
    public void releaseAll() {
        Object o = this.data();
        if (o instanceof ByteBuf) {
            ((ByteBuf)o).release();
        }
    }
}

