/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.waf.model.ProtectionCapabilitySummary;
import com.oracle.bmc.waf.model.SortOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListProtectionCapabilityGroupTagsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private ProtectionCapabilitySummary.Type type;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String name;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public ProtectionCapabilitySummary.Type getType() {
        return this.type;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getName() {
        return this.name;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).opcRequestId(this.opcRequestId).page(this.page).limit(this.limit).type(this.type).sortOrder(this.sortOrder).sortBy(this.sortBy).name(this.name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",type=").append(String.valueOf((Object)this.type));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",name=").append(String.valueOf(this.name));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListProtectionCapabilityGroupTagsRequest)) {
            return false;
        }
        ListProtectionCapabilityGroupTagsRequest other = (ListProtectionCapabilityGroupTagsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListProtectionCapabilityGroupTagsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String opcRequestId = null;
        private String page = null;
        private Integer limit = null;
        private ProtectionCapabilitySummary.Type type = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String name = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder type(ProtectionCapabilitySummary.Type type) {
            this.type = type;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListProtectionCapabilityGroupTagsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.type(o.getType());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.name(o.getName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListProtectionCapabilityGroupTagsRequest build() {
            ListProtectionCapabilityGroupTagsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListProtectionCapabilityGroupTagsRequest buildWithoutInvocationCallback() {
            ListProtectionCapabilityGroupTagsRequest request = new ListProtectionCapabilityGroupTagsRequest();
            request.compartmentId = this.compartmentId;
            request.opcRequestId = this.opcRequestId;
            request.page = this.page;
            request.limit = this.limit;
            request.type = this.type;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.name = this.name;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Name("name");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

