/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.waf.model.RequestRateLimitingConfiguration;
import com.oracle.bmc.waf.model.WebAppFirewallPolicyRule;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class RequestRateLimitingRule
extends WebAppFirewallPolicyRule {
    @JsonProperty(value="configurations")
    private final List<RequestRateLimitingConfiguration> configurations;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public RequestRateLimitingRule(String name, WebAppFirewallPolicyRule.ConditionLanguage conditionLanguage, String condition, String actionName, List<RequestRateLimitingConfiguration> configurations) {
        super(name, conditionLanguage, condition, actionName);
        this.configurations = configurations;
    }

    public List<RequestRateLimitingConfiguration> getConfigurations() {
        return this.configurations;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RequestRateLimitingRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", configurations=").append(String.valueOf(this.configurations));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestRateLimitingRule)) {
            return false;
        }
        RequestRateLimitingRule other = (RequestRateLimitingRule)((Object)o);
        return Objects.equals(this.configurations, other.configurations) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.configurations == null ? 43 : this.configurations.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="conditionLanguage")
        private WebAppFirewallPolicyRule.ConditionLanguage conditionLanguage;
        @JsonProperty(value="condition")
        private String condition;
        @JsonProperty(value="actionName")
        private String actionName;
        @JsonProperty(value="configurations")
        private List<RequestRateLimitingConfiguration> configurations;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder conditionLanguage(WebAppFirewallPolicyRule.ConditionLanguage conditionLanguage) {
            this.conditionLanguage = conditionLanguage;
            this.__explicitlySet__.add("conditionLanguage");
            return this;
        }

        public Builder condition(String condition) {
            this.condition = condition;
            this.__explicitlySet__.add("condition");
            return this;
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.__explicitlySet__.add("actionName");
            return this;
        }

        public Builder configurations(List<RequestRateLimitingConfiguration> configurations) {
            this.configurations = configurations;
            this.__explicitlySet__.add("configurations");
            return this;
        }

        public RequestRateLimitingRule build() {
            RequestRateLimitingRule model = new RequestRateLimitingRule(this.name, this.conditionLanguage, this.condition, this.actionName, this.configurations);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RequestRateLimitingRule model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("conditionLanguage")) {
                this.conditionLanguage(model.getConditionLanguage());
            }
            if (model.wasPropertyExplicitlySet("condition")) {
                this.condition(model.getCondition());
            }
            if (model.wasPropertyExplicitlySet("actionName")) {
                this.actionName(model.getActionName());
            }
            if (model.wasPropertyExplicitlySet("configurations")) {
                this.configurations(model.getConfigurations());
            }
            return this;
        }
    }
}

