/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.waf.model.ProtectionCapability;
import com.oracle.bmc.waf.model.ProtectionCapabilitySettings;
import com.oracle.bmc.waf.model.WebAppFirewallPolicyRule;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class ProtectionRule
extends WebAppFirewallPolicyRule {
    @JsonProperty(value="protectionCapabilities")
    private final List<ProtectionCapability> protectionCapabilities;
    @JsonProperty(value="protectionCapabilitySettings")
    private final ProtectionCapabilitySettings protectionCapabilitySettings;
    @JsonProperty(value="isBodyInspectionEnabled")
    private final Boolean isBodyInspectionEnabled;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ProtectionRule(String name, WebAppFirewallPolicyRule.ConditionLanguage conditionLanguage, String condition, String actionName, List<ProtectionCapability> protectionCapabilities, ProtectionCapabilitySettings protectionCapabilitySettings, Boolean isBodyInspectionEnabled) {
        super(name, conditionLanguage, condition, actionName);
        this.protectionCapabilities = protectionCapabilities;
        this.protectionCapabilitySettings = protectionCapabilitySettings;
        this.isBodyInspectionEnabled = isBodyInspectionEnabled;
    }

    public List<ProtectionCapability> getProtectionCapabilities() {
        return this.protectionCapabilities;
    }

    public ProtectionCapabilitySettings getProtectionCapabilitySettings() {
        return this.protectionCapabilitySettings;
    }

    public Boolean getIsBodyInspectionEnabled() {
        return this.isBodyInspectionEnabled;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProtectionRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", protectionCapabilities=").append(String.valueOf(this.protectionCapabilities));
        sb.append(", protectionCapabilitySettings=").append(String.valueOf((Object)this.protectionCapabilitySettings));
        sb.append(", isBodyInspectionEnabled=").append(String.valueOf(this.isBodyInspectionEnabled));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProtectionRule)) {
            return false;
        }
        ProtectionRule other = (ProtectionRule)((Object)o);
        return Objects.equals(this.protectionCapabilities, other.protectionCapabilities) && Objects.equals((Object)this.protectionCapabilitySettings, (Object)other.protectionCapabilitySettings) && Objects.equals(this.isBodyInspectionEnabled, other.isBodyInspectionEnabled) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.protectionCapabilities == null ? 43 : this.protectionCapabilities.hashCode());
        result = result * 59 + (this.protectionCapabilitySettings == null ? 43 : this.protectionCapabilitySettings.hashCode());
        result = result * 59 + (this.isBodyInspectionEnabled == null ? 43 : this.isBodyInspectionEnabled.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="conditionLanguage")
        private WebAppFirewallPolicyRule.ConditionLanguage conditionLanguage;
        @JsonProperty(value="condition")
        private String condition;
        @JsonProperty(value="actionName")
        private String actionName;
        @JsonProperty(value="protectionCapabilities")
        private List<ProtectionCapability> protectionCapabilities;
        @JsonProperty(value="protectionCapabilitySettings")
        private ProtectionCapabilitySettings protectionCapabilitySettings;
        @JsonProperty(value="isBodyInspectionEnabled")
        private Boolean isBodyInspectionEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder conditionLanguage(WebAppFirewallPolicyRule.ConditionLanguage conditionLanguage) {
            this.conditionLanguage = conditionLanguage;
            this.__explicitlySet__.add("conditionLanguage");
            return this;
        }

        public Builder condition(String condition) {
            this.condition = condition;
            this.__explicitlySet__.add("condition");
            return this;
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.__explicitlySet__.add("actionName");
            return this;
        }

        public Builder protectionCapabilities(List<ProtectionCapability> protectionCapabilities) {
            this.protectionCapabilities = protectionCapabilities;
            this.__explicitlySet__.add("protectionCapabilities");
            return this;
        }

        public Builder protectionCapabilitySettings(ProtectionCapabilitySettings protectionCapabilitySettings) {
            this.protectionCapabilitySettings = protectionCapabilitySettings;
            this.__explicitlySet__.add("protectionCapabilitySettings");
            return this;
        }

        public Builder isBodyInspectionEnabled(Boolean isBodyInspectionEnabled) {
            this.isBodyInspectionEnabled = isBodyInspectionEnabled;
            this.__explicitlySet__.add("isBodyInspectionEnabled");
            return this;
        }

        public ProtectionRule build() {
            ProtectionRule model = new ProtectionRule(this.name, this.conditionLanguage, this.condition, this.actionName, this.protectionCapabilities, this.protectionCapabilitySettings, this.isBodyInspectionEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProtectionRule model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("conditionLanguage")) {
                this.conditionLanguage(model.getConditionLanguage());
            }
            if (model.wasPropertyExplicitlySet("condition")) {
                this.condition(model.getCondition());
            }
            if (model.wasPropertyExplicitlySet("actionName")) {
                this.actionName(model.getActionName());
            }
            if (model.wasPropertyExplicitlySet("protectionCapabilities")) {
                this.protectionCapabilities(model.getProtectionCapabilities());
            }
            if (model.wasPropertyExplicitlySet("protectionCapabilitySettings")) {
                this.protectionCapabilitySettings(model.getProtectionCapabilitySettings());
            }
            if (model.wasPropertyExplicitlySet("isBodyInspectionEnabled")) {
                this.isBodyInspectionEnabled(model.getIsBodyInspectionEnabled());
            }
            return this;
        }
    }
}

