/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.waf.model.CollaborativeCapabilityWeightOverride;
import com.oracle.bmc.waf.model.ProtectionCapabilityExclusions;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProtectionCapability
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="version")
    private final Integer version;
    @JsonProperty(value="exclusions")
    private final ProtectionCapabilityExclusions exclusions;
    @JsonProperty(value="actionName")
    private final String actionName;
    @JsonProperty(value="collaborativeActionThreshold")
    private final Integer collaborativeActionThreshold;
    @JsonProperty(value="collaborativeWeights")
    private final List<CollaborativeCapabilityWeightOverride> collaborativeWeights;

    @Deprecated
    @ConstructorProperties(value={"key", "version", "exclusions", "actionName", "collaborativeActionThreshold", "collaborativeWeights"})
    public ProtectionCapability(String key, Integer version, ProtectionCapabilityExclusions exclusions, String actionName, Integer collaborativeActionThreshold, List<CollaborativeCapabilityWeightOverride> collaborativeWeights) {
        this.key = key;
        this.version = version;
        this.exclusions = exclusions;
        this.actionName = actionName;
        this.collaborativeActionThreshold = collaborativeActionThreshold;
        this.collaborativeWeights = collaborativeWeights;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public Integer getVersion() {
        return this.version;
    }

    public ProtectionCapabilityExclusions getExclusions() {
        return this.exclusions;
    }

    public String getActionName() {
        return this.actionName;
    }

    public Integer getCollaborativeActionThreshold() {
        return this.collaborativeActionThreshold;
    }

    public List<CollaborativeCapabilityWeightOverride> getCollaborativeWeights() {
        return this.collaborativeWeights;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProtectionCapability(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", exclusions=").append(String.valueOf((Object)this.exclusions));
        sb.append(", actionName=").append(String.valueOf(this.actionName));
        sb.append(", collaborativeActionThreshold=").append(String.valueOf(this.collaborativeActionThreshold));
        sb.append(", collaborativeWeights=").append(String.valueOf(this.collaborativeWeights));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProtectionCapability)) {
            return false;
        }
        ProtectionCapability other = (ProtectionCapability)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.version, other.version) && Objects.equals((Object)this.exclusions, (Object)other.exclusions) && Objects.equals(this.actionName, other.actionName) && Objects.equals(this.collaborativeActionThreshold, other.collaborativeActionThreshold) && Objects.equals(this.collaborativeWeights, other.collaborativeWeights) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.exclusions == null ? 43 : this.exclusions.hashCode());
        result = result * 59 + (this.actionName == null ? 43 : this.actionName.hashCode());
        result = result * 59 + (this.collaborativeActionThreshold == null ? 43 : this.collaborativeActionThreshold.hashCode());
        result = result * 59 + (this.collaborativeWeights == null ? 43 : this.collaborativeWeights.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="version")
        private Integer version;
        @JsonProperty(value="exclusions")
        private ProtectionCapabilityExclusions exclusions;
        @JsonProperty(value="actionName")
        private String actionName;
        @JsonProperty(value="collaborativeActionThreshold")
        private Integer collaborativeActionThreshold;
        @JsonProperty(value="collaborativeWeights")
        private List<CollaborativeCapabilityWeightOverride> collaborativeWeights;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder exclusions(ProtectionCapabilityExclusions exclusions) {
            this.exclusions = exclusions;
            this.__explicitlySet__.add("exclusions");
            return this;
        }

        public Builder actionName(String actionName) {
            this.actionName = actionName;
            this.__explicitlySet__.add("actionName");
            return this;
        }

        public Builder collaborativeActionThreshold(Integer collaborativeActionThreshold) {
            this.collaborativeActionThreshold = collaborativeActionThreshold;
            this.__explicitlySet__.add("collaborativeActionThreshold");
            return this;
        }

        public Builder collaborativeWeights(List<CollaborativeCapabilityWeightOverride> collaborativeWeights) {
            this.collaborativeWeights = collaborativeWeights;
            this.__explicitlySet__.add("collaborativeWeights");
            return this;
        }

        public ProtectionCapability build() {
            ProtectionCapability model = new ProtectionCapability(this.key, this.version, this.exclusions, this.actionName, this.collaborativeActionThreshold, this.collaborativeWeights);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProtectionCapability model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("exclusions")) {
                this.exclusions(model.getExclusions());
            }
            if (model.wasPropertyExplicitlySet("actionName")) {
                this.actionName(model.getActionName());
            }
            if (model.wasPropertyExplicitlySet("collaborativeActionThreshold")) {
                this.collaborativeActionThreshold(model.getCollaborativeActionThreshold());
            }
            if (model.wasPropertyExplicitlySet("collaborativeWeights")) {
                this.collaborativeWeights(model.getCollaborativeWeights());
            }
            return this;
        }
    }
}

