/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf;

import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waf.Waf;
import com.oracle.bmc.waf.model.NetworkAddressList;
import com.oracle.bmc.waf.model.WebAppFirewall;
import com.oracle.bmc.waf.model.WebAppFirewallPolicy;
import com.oracle.bmc.waf.requests.GetNetworkAddressListRequest;
import com.oracle.bmc.waf.requests.GetWebAppFirewallPolicyRequest;
import com.oracle.bmc.waf.requests.GetWebAppFirewallRequest;
import com.oracle.bmc.waf.requests.GetWorkRequestRequest;
import com.oracle.bmc.waf.responses.GetNetworkAddressListResponse;
import com.oracle.bmc.waf.responses.GetWebAppFirewallPolicyResponse;
import com.oracle.bmc.waf.responses.GetWebAppFirewallResponse;
import com.oracle.bmc.waf.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class WafWaiters {
    private final ExecutorService executorService;
    private final Waf client;

    public WafWaiters(ExecutorService executorService, Waf client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetNetworkAddressListRequest, GetNetworkAddressListResponse> forNetworkAddressList(GetNetworkAddressListRequest request, NetworkAddressList.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forNetworkAddressList(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetNetworkAddressListRequest, GetNetworkAddressListResponse> forNetworkAddressList(GetNetworkAddressListRequest request, NetworkAddressList.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forNetworkAddressList(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetNetworkAddressListRequest, GetNetworkAddressListResponse> forNetworkAddressList(GetNetworkAddressListRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, NetworkAddressList.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forNetworkAddressList(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetNetworkAddressListRequest, GetNetworkAddressListResponse> forNetworkAddressList(BmcGenericWaiter waiter, GetNetworkAddressListRequest request, NetworkAddressList.LifecycleState ... targetStates) {
        final HashSet<NetworkAddressList.LifecycleState> targetStatesSet = new HashSet<NetworkAddressList.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetNetworkAddressListRequest, GetNetworkAddressListResponse>(){

            @Override
            public GetNetworkAddressListResponse apply(GetNetworkAddressListRequest request) {
                return WafWaiters.this.client.getNetworkAddressList(request);
            }
        }, (Predicate)new Predicate<GetNetworkAddressListResponse>(){

            @Override
            public boolean test(GetNetworkAddressListResponse response) {
                return targetStatesSet.contains((Object)response.getNetworkAddressList().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)NetworkAddressList.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWebAppFirewallRequest, GetWebAppFirewallResponse> forWebAppFirewall(GetWebAppFirewallRequest request, WebAppFirewall.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forWebAppFirewall(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetWebAppFirewallRequest, GetWebAppFirewallResponse> forWebAppFirewall(GetWebAppFirewallRequest request, WebAppFirewall.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forWebAppFirewall(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetWebAppFirewallRequest, GetWebAppFirewallResponse> forWebAppFirewall(GetWebAppFirewallRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, WebAppFirewall.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forWebAppFirewall(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetWebAppFirewallRequest, GetWebAppFirewallResponse> forWebAppFirewall(BmcGenericWaiter waiter, GetWebAppFirewallRequest request, WebAppFirewall.LifecycleState ... targetStates) {
        final HashSet<WebAppFirewall.LifecycleState> targetStatesSet = new HashSet<WebAppFirewall.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWebAppFirewallRequest, GetWebAppFirewallResponse>(){

            @Override
            public GetWebAppFirewallResponse apply(GetWebAppFirewallRequest request) {
                return WafWaiters.this.client.getWebAppFirewall(request);
            }
        }, (Predicate)new Predicate<GetWebAppFirewallResponse>(){

            @Override
            public boolean test(GetWebAppFirewallResponse response) {
                return targetStatesSet.contains((Object)response.getWebAppFirewall().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)WebAppFirewall.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWebAppFirewallPolicyRequest, GetWebAppFirewallPolicyResponse> forWebAppFirewallPolicy(GetWebAppFirewallPolicyRequest request, WebAppFirewallPolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forWebAppFirewallPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetWebAppFirewallPolicyRequest, GetWebAppFirewallPolicyResponse> forWebAppFirewallPolicy(GetWebAppFirewallPolicyRequest request, WebAppFirewallPolicy.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forWebAppFirewallPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetWebAppFirewallPolicyRequest, GetWebAppFirewallPolicyResponse> forWebAppFirewallPolicy(GetWebAppFirewallPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, WebAppFirewallPolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forWebAppFirewallPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetWebAppFirewallPolicyRequest, GetWebAppFirewallPolicyResponse> forWebAppFirewallPolicy(BmcGenericWaiter waiter, GetWebAppFirewallPolicyRequest request, WebAppFirewallPolicy.LifecycleState ... targetStates) {
        final HashSet<WebAppFirewallPolicy.LifecycleState> targetStatesSet = new HashSet<WebAppFirewallPolicy.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWebAppFirewallPolicyRequest, GetWebAppFirewallPolicyResponse>(){

            @Override
            public GetWebAppFirewallPolicyResponse apply(GetWebAppFirewallPolicyRequest request) {
                return WafWaiters.this.client.getWebAppFirewallPolicy(request);
            }
        }, (Predicate)new Predicate<GetWebAppFirewallPolicyResponse>(){

            @Override
            public boolean test(GetWebAppFirewallPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getWebAppFirewallPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)WebAppFirewallPolicy.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return WafWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

