/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.waf.Waf;
import com.oracle.bmc.waf.model.NetworkAddressListSummary;
import com.oracle.bmc.waf.model.ProtectionCapabilityGroupTagSummary;
import com.oracle.bmc.waf.model.ProtectionCapabilitySummary;
import com.oracle.bmc.waf.model.WebAppFirewallPolicySummary;
import com.oracle.bmc.waf.model.WebAppFirewallSummary;
import com.oracle.bmc.waf.model.WorkRequest;
import com.oracle.bmc.waf.model.WorkRequestError;
import com.oracle.bmc.waf.model.WorkRequestLogEntry;
import com.oracle.bmc.waf.requests.ListNetworkAddressListsRequest;
import com.oracle.bmc.waf.requests.ListProtectionCapabilitiesRequest;
import com.oracle.bmc.waf.requests.ListProtectionCapabilityGroupTagsRequest;
import com.oracle.bmc.waf.requests.ListWebAppFirewallPoliciesRequest;
import com.oracle.bmc.waf.requests.ListWebAppFirewallsRequest;
import com.oracle.bmc.waf.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.waf.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.waf.requests.ListWorkRequestsRequest;
import com.oracle.bmc.waf.responses.ListNetworkAddressListsResponse;
import com.oracle.bmc.waf.responses.ListProtectionCapabilitiesResponse;
import com.oracle.bmc.waf.responses.ListProtectionCapabilityGroupTagsResponse;
import com.oracle.bmc.waf.responses.ListWebAppFirewallPoliciesResponse;
import com.oracle.bmc.waf.responses.ListWebAppFirewallsResponse;
import com.oracle.bmc.waf.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.waf.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.waf.responses.ListWorkRequestsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class WafPaginators {
    private final Waf client;

    public WafPaginators(Waf client) {
        this.client = client;
    }

    public Iterable<ListNetworkAddressListsResponse> listNetworkAddressListsResponseIterator(final ListNetworkAddressListsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListNetworkAddressListsRequest.Builder>(){

            @Override
            public ListNetworkAddressListsRequest.Builder get() {
                return ListNetworkAddressListsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNetworkAddressListsResponse, String>(){

            @Override
            public String apply(ListNetworkAddressListsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNetworkAddressListsRequest.Builder>, ListNetworkAddressListsRequest>(){

            @Override
            public ListNetworkAddressListsRequest apply(RequestBuilderAndToken<ListNetworkAddressListsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNetworkAddressListsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNetworkAddressListsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNetworkAddressListsRequest, ListNetworkAddressListsResponse>(){

            @Override
            public ListNetworkAddressListsResponse apply(ListNetworkAddressListsRequest request) {
                return WafPaginators.this.client.listNetworkAddressLists(request);
            }
        });
    }

    public Iterable<NetworkAddressListSummary> listNetworkAddressListsRecordIterator(final ListNetworkAddressListsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListNetworkAddressListsRequest.Builder>(){

            @Override
            public ListNetworkAddressListsRequest.Builder get() {
                return ListNetworkAddressListsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListNetworkAddressListsResponse, String>(){

            @Override
            public String apply(ListNetworkAddressListsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListNetworkAddressListsRequest.Builder>, ListNetworkAddressListsRequest>(){

            @Override
            public ListNetworkAddressListsRequest apply(RequestBuilderAndToken<ListNetworkAddressListsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListNetworkAddressListsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListNetworkAddressListsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListNetworkAddressListsRequest, ListNetworkAddressListsResponse>(){

            @Override
            public ListNetworkAddressListsResponse apply(ListNetworkAddressListsRequest request) {
                return WafPaginators.this.client.listNetworkAddressLists(request);
            }
        }, (Function)new Function<ListNetworkAddressListsResponse, List<NetworkAddressListSummary>>(){

            @Override
            public List<NetworkAddressListSummary> apply(ListNetworkAddressListsResponse response) {
                return response.getNetworkAddressListCollection().getItems();
            }
        });
    }

    public Iterable<ListProtectionCapabilitiesResponse> listProtectionCapabilitiesResponseIterator(final ListProtectionCapabilitiesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProtectionCapabilitiesRequest.Builder>(){

            @Override
            public ListProtectionCapabilitiesRequest.Builder get() {
                return ListProtectionCapabilitiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProtectionCapabilitiesResponse, String>(){

            @Override
            public String apply(ListProtectionCapabilitiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProtectionCapabilitiesRequest.Builder>, ListProtectionCapabilitiesRequest>(){

            @Override
            public ListProtectionCapabilitiesRequest apply(RequestBuilderAndToken<ListProtectionCapabilitiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProtectionCapabilitiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProtectionCapabilitiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProtectionCapabilitiesRequest, ListProtectionCapabilitiesResponse>(){

            @Override
            public ListProtectionCapabilitiesResponse apply(ListProtectionCapabilitiesRequest request) {
                return WafPaginators.this.client.listProtectionCapabilities(request);
            }
        });
    }

    public Iterable<ProtectionCapabilitySummary> listProtectionCapabilitiesRecordIterator(final ListProtectionCapabilitiesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProtectionCapabilitiesRequest.Builder>(){

            @Override
            public ListProtectionCapabilitiesRequest.Builder get() {
                return ListProtectionCapabilitiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProtectionCapabilitiesResponse, String>(){

            @Override
            public String apply(ListProtectionCapabilitiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProtectionCapabilitiesRequest.Builder>, ListProtectionCapabilitiesRequest>(){

            @Override
            public ListProtectionCapabilitiesRequest apply(RequestBuilderAndToken<ListProtectionCapabilitiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProtectionCapabilitiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProtectionCapabilitiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProtectionCapabilitiesRequest, ListProtectionCapabilitiesResponse>(){

            @Override
            public ListProtectionCapabilitiesResponse apply(ListProtectionCapabilitiesRequest request) {
                return WafPaginators.this.client.listProtectionCapabilities(request);
            }
        }, (Function)new Function<ListProtectionCapabilitiesResponse, List<ProtectionCapabilitySummary>>(){

            @Override
            public List<ProtectionCapabilitySummary> apply(ListProtectionCapabilitiesResponse response) {
                return response.getProtectionCapabilityCollection().getItems();
            }
        });
    }

    public Iterable<ListProtectionCapabilityGroupTagsResponse> listProtectionCapabilityGroupTagsResponseIterator(final ListProtectionCapabilityGroupTagsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProtectionCapabilityGroupTagsRequest.Builder>(){

            @Override
            public ListProtectionCapabilityGroupTagsRequest.Builder get() {
                return ListProtectionCapabilityGroupTagsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProtectionCapabilityGroupTagsResponse, String>(){

            @Override
            public String apply(ListProtectionCapabilityGroupTagsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProtectionCapabilityGroupTagsRequest.Builder>, ListProtectionCapabilityGroupTagsRequest>(){

            @Override
            public ListProtectionCapabilityGroupTagsRequest apply(RequestBuilderAndToken<ListProtectionCapabilityGroupTagsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProtectionCapabilityGroupTagsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProtectionCapabilityGroupTagsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProtectionCapabilityGroupTagsRequest, ListProtectionCapabilityGroupTagsResponse>(){

            @Override
            public ListProtectionCapabilityGroupTagsResponse apply(ListProtectionCapabilityGroupTagsRequest request) {
                return WafPaginators.this.client.listProtectionCapabilityGroupTags(request);
            }
        });
    }

    public Iterable<ProtectionCapabilityGroupTagSummary> listProtectionCapabilityGroupTagsRecordIterator(final ListProtectionCapabilityGroupTagsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProtectionCapabilityGroupTagsRequest.Builder>(){

            @Override
            public ListProtectionCapabilityGroupTagsRequest.Builder get() {
                return ListProtectionCapabilityGroupTagsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProtectionCapabilityGroupTagsResponse, String>(){

            @Override
            public String apply(ListProtectionCapabilityGroupTagsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProtectionCapabilityGroupTagsRequest.Builder>, ListProtectionCapabilityGroupTagsRequest>(){

            @Override
            public ListProtectionCapabilityGroupTagsRequest apply(RequestBuilderAndToken<ListProtectionCapabilityGroupTagsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListProtectionCapabilityGroupTagsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProtectionCapabilityGroupTagsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListProtectionCapabilityGroupTagsRequest, ListProtectionCapabilityGroupTagsResponse>(){

            @Override
            public ListProtectionCapabilityGroupTagsResponse apply(ListProtectionCapabilityGroupTagsRequest request) {
                return WafPaginators.this.client.listProtectionCapabilityGroupTags(request);
            }
        }, (Function)new Function<ListProtectionCapabilityGroupTagsResponse, List<ProtectionCapabilityGroupTagSummary>>(){

            @Override
            public List<ProtectionCapabilityGroupTagSummary> apply(ListProtectionCapabilityGroupTagsResponse response) {
                return response.getProtectionCapabilityGroupTagCollection().getItems();
            }
        });
    }

    public Iterable<ListWebAppFirewallPoliciesResponse> listWebAppFirewallPoliciesResponseIterator(final ListWebAppFirewallPoliciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWebAppFirewallPoliciesRequest.Builder>(){

            @Override
            public ListWebAppFirewallPoliciesRequest.Builder get() {
                return ListWebAppFirewallPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWebAppFirewallPoliciesResponse, String>(){

            @Override
            public String apply(ListWebAppFirewallPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWebAppFirewallPoliciesRequest.Builder>, ListWebAppFirewallPoliciesRequest>(){

            @Override
            public ListWebAppFirewallPoliciesRequest apply(RequestBuilderAndToken<ListWebAppFirewallPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWebAppFirewallPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWebAppFirewallPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWebAppFirewallPoliciesRequest, ListWebAppFirewallPoliciesResponse>(){

            @Override
            public ListWebAppFirewallPoliciesResponse apply(ListWebAppFirewallPoliciesRequest request) {
                return WafPaginators.this.client.listWebAppFirewallPolicies(request);
            }
        });
    }

    public Iterable<WebAppFirewallPolicySummary> listWebAppFirewallPoliciesRecordIterator(final ListWebAppFirewallPoliciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWebAppFirewallPoliciesRequest.Builder>(){

            @Override
            public ListWebAppFirewallPoliciesRequest.Builder get() {
                return ListWebAppFirewallPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWebAppFirewallPoliciesResponse, String>(){

            @Override
            public String apply(ListWebAppFirewallPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWebAppFirewallPoliciesRequest.Builder>, ListWebAppFirewallPoliciesRequest>(){

            @Override
            public ListWebAppFirewallPoliciesRequest apply(RequestBuilderAndToken<ListWebAppFirewallPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWebAppFirewallPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWebAppFirewallPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWebAppFirewallPoliciesRequest, ListWebAppFirewallPoliciesResponse>(){

            @Override
            public ListWebAppFirewallPoliciesResponse apply(ListWebAppFirewallPoliciesRequest request) {
                return WafPaginators.this.client.listWebAppFirewallPolicies(request);
            }
        }, (Function)new Function<ListWebAppFirewallPoliciesResponse, List<WebAppFirewallPolicySummary>>(){

            @Override
            public List<WebAppFirewallPolicySummary> apply(ListWebAppFirewallPoliciesResponse response) {
                return response.getWebAppFirewallPolicyCollection().getItems();
            }
        });
    }

    public Iterable<ListWebAppFirewallsResponse> listWebAppFirewallsResponseIterator(final ListWebAppFirewallsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWebAppFirewallsRequest.Builder>(){

            @Override
            public ListWebAppFirewallsRequest.Builder get() {
                return ListWebAppFirewallsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWebAppFirewallsResponse, String>(){

            @Override
            public String apply(ListWebAppFirewallsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWebAppFirewallsRequest.Builder>, ListWebAppFirewallsRequest>(){

            @Override
            public ListWebAppFirewallsRequest apply(RequestBuilderAndToken<ListWebAppFirewallsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWebAppFirewallsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWebAppFirewallsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWebAppFirewallsRequest, ListWebAppFirewallsResponse>(){

            @Override
            public ListWebAppFirewallsResponse apply(ListWebAppFirewallsRequest request) {
                return WafPaginators.this.client.listWebAppFirewalls(request);
            }
        });
    }

    public Iterable<WebAppFirewallSummary> listWebAppFirewallsRecordIterator(final ListWebAppFirewallsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWebAppFirewallsRequest.Builder>(){

            @Override
            public ListWebAppFirewallsRequest.Builder get() {
                return ListWebAppFirewallsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWebAppFirewallsResponse, String>(){

            @Override
            public String apply(ListWebAppFirewallsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWebAppFirewallsRequest.Builder>, ListWebAppFirewallsRequest>(){

            @Override
            public ListWebAppFirewallsRequest apply(RequestBuilderAndToken<ListWebAppFirewallsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWebAppFirewallsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWebAppFirewallsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWebAppFirewallsRequest, ListWebAppFirewallsResponse>(){

            @Override
            public ListWebAppFirewallsResponse apply(ListWebAppFirewallsRequest request) {
                return WafPaginators.this.client.listWebAppFirewalls(request);
            }
        }, (Function)new Function<ListWebAppFirewallsResponse, List<WebAppFirewallSummary>>(){

            @Override
            public List<WebAppFirewallSummary> apply(ListWebAppFirewallsResponse response) {
                return response.getWebAppFirewallCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return WafPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return WafPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return WafPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return WafPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return WafPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequest> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return WafPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequest>>(){

            @Override
            public List<WorkRequest> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }
}

