/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.waas.model.ThreatFeedAction;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class UpdateThreatFeedsRequest
extends BmcRequest<List<ThreatFeedAction>> {
    private String waasPolicyId;
    private List<ThreatFeedAction> threatFeeds;
    private String opcRequestId;
    private String ifMatch;

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public List<ThreatFeedAction> getThreatFeeds() {
        return this.threatFeeds;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public List<ThreatFeedAction> getBody$() {
        return this.threatFeeds;
    }

    public Builder toBuilder() {
        return new Builder().waasPolicyId(this.waasPolicyId).threatFeeds(this.threatFeeds).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",waasPolicyId=").append(String.valueOf(this.waasPolicyId));
        sb.append(",threatFeeds=").append(String.valueOf(this.threatFeeds));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateThreatFeedsRequest)) {
            return false;
        }
        UpdateThreatFeedsRequest other = (UpdateThreatFeedsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.waasPolicyId, other.waasPolicyId) && Objects.equals(this.threatFeeds, other.threatFeeds) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.waasPolicyId == null ? 43 : this.waasPolicyId.hashCode());
        result = result * 59 + (this.threatFeeds == null ? 43 : this.threatFeeds.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateThreatFeedsRequest, List<ThreatFeedAction>> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String waasPolicyId = null;
        private List<ThreatFeedAction> threatFeeds = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder threatFeeds(List<ThreatFeedAction> threatFeeds) {
            this.threatFeeds = threatFeeds;
            return this;
        }

        public Builder threatFeeds(ThreatFeedAction singularValue) {
            return this.threatFeeds(Arrays.asList(singularValue));
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateThreatFeedsRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.threatFeeds(o.getThreatFeeds());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateThreatFeedsRequest build() {
            UpdateThreatFeedsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(List<ThreatFeedAction> body) {
            this.threatFeeds(body);
            return this;
        }

        public UpdateThreatFeedsRequest buildWithoutInvocationCallback() {
            UpdateThreatFeedsRequest request = new UpdateThreatFeedsRequest();
            request.waasPolicyId = this.waasPolicyId;
            request.threatFeeds = this.threatFeeds;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

