/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.waas.model.UpdateAddressListDetails;
import java.util.Objects;

public class UpdateAddressListRequest
extends BmcRequest<UpdateAddressListDetails> {
    private String addressListId;
    private String opcRequestId;
    private String ifMatch;
    private UpdateAddressListDetails updateAddressListDetails;

    public String getAddressListId() {
        return this.addressListId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public UpdateAddressListDetails getUpdateAddressListDetails() {
        return this.updateAddressListDetails;
    }

    @InternalSdk
    public UpdateAddressListDetails getBody$() {
        return this.updateAddressListDetails;
    }

    public Builder toBuilder() {
        return new Builder().addressListId(this.addressListId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).updateAddressListDetails(this.updateAddressListDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",addressListId=").append(String.valueOf(this.addressListId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",updateAddressListDetails=").append(String.valueOf((Object)this.updateAddressListDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAddressListRequest)) {
            return false;
        }
        UpdateAddressListRequest other = (UpdateAddressListRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.addressListId, other.addressListId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals((Object)this.updateAddressListDetails, (Object)other.updateAddressListDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.addressListId == null ? 43 : this.addressListId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.updateAddressListDetails == null ? 43 : this.updateAddressListDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateAddressListRequest, UpdateAddressListDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String addressListId = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private UpdateAddressListDetails updateAddressListDetails = null;

        public Builder addressListId(String addressListId) {
            this.addressListId = addressListId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder updateAddressListDetails(UpdateAddressListDetails updateAddressListDetails) {
            this.updateAddressListDetails = updateAddressListDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAddressListRequest o) {
            this.addressListId(o.getAddressListId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.updateAddressListDetails(o.getUpdateAddressListDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAddressListRequest build() {
            UpdateAddressListRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateAddressListDetails body) {
            this.updateAddressListDetails(body);
            return this;
        }

        public UpdateAddressListRequest buildWithoutInvocationCallback() {
            UpdateAddressListRequest request = new UpdateAddressListRequest();
            request.addressListId = this.addressListId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.updateAddressListDetails = this.updateAddressListDetails;
            return request;
        }
    }
}

