/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetProtectionRuleRequest
extends BmcRequest<Void> {
    private String waasPolicyId;
    private String protectionRuleKey;
    private String opcRequestId;

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public String getProtectionRuleKey() {
        return this.protectionRuleKey;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().waasPolicyId(this.waasPolicyId).protectionRuleKey(this.protectionRuleKey).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",waasPolicyId=").append(String.valueOf(this.waasPolicyId));
        sb.append(",protectionRuleKey=").append(String.valueOf(this.protectionRuleKey));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetProtectionRuleRequest)) {
            return false;
        }
        GetProtectionRuleRequest other = (GetProtectionRuleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.waasPolicyId, other.waasPolicyId) && Objects.equals(this.protectionRuleKey, other.protectionRuleKey) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.waasPolicyId == null ? 43 : this.waasPolicyId.hashCode());
        result = result * 59 + (this.protectionRuleKey == null ? 43 : this.protectionRuleKey.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetProtectionRuleRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String waasPolicyId = null;
        private String protectionRuleKey = null;
        private String opcRequestId = null;

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder protectionRuleKey(String protectionRuleKey) {
            this.protectionRuleKey = protectionRuleKey;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetProtectionRuleRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.protectionRuleKey(o.getProtectionRuleKey());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetProtectionRuleRequest build() {
            GetProtectionRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetProtectionRuleRequest buildWithoutInvocationCallback() {
            GetProtectionRuleRequest request = new GetProtectionRuleRequest();
            request.waasPolicyId = this.waasPolicyId;
            request.protectionRuleKey = this.protectionRuleKey;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

