/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCustomProtectionRuleRequest
extends BmcRequest<Void> {
    private String customProtectionRuleId;
    private String opcRequestId;

    public String getCustomProtectionRuleId() {
        return this.customProtectionRuleId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().customProtectionRuleId(this.customProtectionRuleId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",customProtectionRuleId=").append(String.valueOf(this.customProtectionRuleId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCustomProtectionRuleRequest)) {
            return false;
        }
        GetCustomProtectionRuleRequest other = (GetCustomProtectionRuleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.customProtectionRuleId, other.customProtectionRuleId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.customProtectionRuleId == null ? 43 : this.customProtectionRuleId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCustomProtectionRuleRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String customProtectionRuleId = null;
        private String opcRequestId = null;

        public Builder customProtectionRuleId(String customProtectionRuleId) {
            this.customProtectionRuleId = customProtectionRuleId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCustomProtectionRuleRequest o) {
            this.customProtectionRuleId(o.getCustomProtectionRuleId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCustomProtectionRuleRequest build() {
            GetCustomProtectionRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCustomProtectionRuleRequest buildWithoutInvocationCallback() {
            GetCustomProtectionRuleRequest request = new GetCustomProtectionRuleRequest();
            request.customProtectionRuleId = this.customProtectionRuleId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

