/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.List;
import java.util.Objects;

public class AcceptRecommendationsRequest
extends BmcRequest<List<String>> {
    private String waasPolicyId;
    private List<String> protectionRuleKeys;
    private String opcRequestId;
    private String ifMatch;

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public List<String> getProtectionRuleKeys() {
        return this.protectionRuleKeys;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public List<String> getBody$() {
        return this.protectionRuleKeys;
    }

    public Builder toBuilder() {
        return new Builder().waasPolicyId(this.waasPolicyId).protectionRuleKeys(this.protectionRuleKeys).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",waasPolicyId=").append(String.valueOf(this.waasPolicyId));
        sb.append(",protectionRuleKeys=").append(String.valueOf(this.protectionRuleKeys));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AcceptRecommendationsRequest)) {
            return false;
        }
        AcceptRecommendationsRequest other = (AcceptRecommendationsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.waasPolicyId, other.waasPolicyId) && Objects.equals(this.protectionRuleKeys, other.protectionRuleKeys) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.waasPolicyId == null ? 43 : this.waasPolicyId.hashCode());
        result = result * 59 + (this.protectionRuleKeys == null ? 43 : this.protectionRuleKeys.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<AcceptRecommendationsRequest, List<String>> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String waasPolicyId = null;
        private List<String> protectionRuleKeys = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder protectionRuleKeys(List<String> protectionRuleKeys) {
            this.protectionRuleKeys = protectionRuleKeys;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AcceptRecommendationsRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.protectionRuleKeys(o.getProtectionRuleKeys());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AcceptRecommendationsRequest build() {
            AcceptRecommendationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(List<String> body) {
            this.protectionRuleKeys(body);
            return this;
        }

        public AcceptRecommendationsRequest buildWithoutInvocationCallback() {
            AcceptRecommendationsRequest request = new AcceptRecommendationsRequest();
            request.waasPolicyId = this.waasPolicyId;
            request.protectionRuleKeys = this.protectionRuleKeys;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

