/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.waas.model.LoadBalancingMethod;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="method")
@JsonFilter(value="explicitlySetFilter")
public final class StickyCookieLoadBalancingMethod
extends LoadBalancingMethod {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="domain")
    private final String domain;
    @JsonProperty(value="expirationTimeInSeconds")
    private final Integer expirationTimeInSeconds;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public StickyCookieLoadBalancingMethod(String name, String domain, Integer expirationTimeInSeconds) {
        this.name = name;
        this.domain = domain;
        this.expirationTimeInSeconds = expirationTimeInSeconds;
    }

    public String getName() {
        return this.name;
    }

    public String getDomain() {
        return this.domain;
    }

    public Integer getExpirationTimeInSeconds() {
        return this.expirationTimeInSeconds;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("StickyCookieLoadBalancingMethod(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", domain=").append(String.valueOf(this.domain));
        sb.append(", expirationTimeInSeconds=").append(String.valueOf(this.expirationTimeInSeconds));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StickyCookieLoadBalancingMethod)) {
            return false;
        }
        StickyCookieLoadBalancingMethod other = (StickyCookieLoadBalancingMethod)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.domain, other.domain) && Objects.equals(this.expirationTimeInSeconds, other.expirationTimeInSeconds) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.domain == null ? 43 : this.domain.hashCode());
        result = result * 59 + (this.expirationTimeInSeconds == null ? 43 : this.expirationTimeInSeconds.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="expirationTimeInSeconds")
        private Integer expirationTimeInSeconds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder expirationTimeInSeconds(Integer expirationTimeInSeconds) {
            this.expirationTimeInSeconds = expirationTimeInSeconds;
            this.__explicitlySet__.add("expirationTimeInSeconds");
            return this;
        }

        public StickyCookieLoadBalancingMethod build() {
            StickyCookieLoadBalancingMethod model = new StickyCookieLoadBalancingMethod(this.name, this.domain, this.expirationTimeInSeconds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(StickyCookieLoadBalancingMethod model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("domain")) {
                this.domain(model.getDomain());
            }
            if (model.wasPropertyExplicitlySet("expirationTimeInSeconds")) {
                this.expirationTimeInSeconds(model.getExpirationTimeInSeconds());
            }
            return this;
        }
    }
}

