/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProtectionSettings
extends ExplicitlySetBmcModel {
    @JsonProperty(value="blockAction")
    private final BlockAction blockAction;
    @JsonProperty(value="blockResponseCode")
    private final Integer blockResponseCode;
    @JsonProperty(value="blockErrorPageMessage")
    private final String blockErrorPageMessage;
    @JsonProperty(value="blockErrorPageCode")
    private final String blockErrorPageCode;
    @JsonProperty(value="blockErrorPageDescription")
    private final String blockErrorPageDescription;
    @JsonProperty(value="maxArgumentCount")
    private final Integer maxArgumentCount;
    @JsonProperty(value="maxNameLengthPerArgument")
    private final Integer maxNameLengthPerArgument;
    @JsonProperty(value="maxTotalNameLengthOfArguments")
    private final Integer maxTotalNameLengthOfArguments;
    @JsonProperty(value="recommendationsPeriodInDays")
    private final Integer recommendationsPeriodInDays;
    @JsonProperty(value="isResponseInspected")
    private final Boolean isResponseInspected;
    @JsonProperty(value="maxResponseSizeInKiB")
    private final Integer maxResponseSizeInKiB;
    @JsonProperty(value="allowedHttpMethods")
    private final List<AllowedHttpMethods> allowedHttpMethods;
    @JsonProperty(value="mediaTypes")
    private final List<String> mediaTypes;

    @Deprecated
    @ConstructorProperties(value={"blockAction", "blockResponseCode", "blockErrorPageMessage", "blockErrorPageCode", "blockErrorPageDescription", "maxArgumentCount", "maxNameLengthPerArgument", "maxTotalNameLengthOfArguments", "recommendationsPeriodInDays", "isResponseInspected", "maxResponseSizeInKiB", "allowedHttpMethods", "mediaTypes"})
    public ProtectionSettings(BlockAction blockAction, Integer blockResponseCode, String blockErrorPageMessage, String blockErrorPageCode, String blockErrorPageDescription, Integer maxArgumentCount, Integer maxNameLengthPerArgument, Integer maxTotalNameLengthOfArguments, Integer recommendationsPeriodInDays, Boolean isResponseInspected, Integer maxResponseSizeInKiB, List<AllowedHttpMethods> allowedHttpMethods, List<String> mediaTypes) {
        this.blockAction = blockAction;
        this.blockResponseCode = blockResponseCode;
        this.blockErrorPageMessage = blockErrorPageMessage;
        this.blockErrorPageCode = blockErrorPageCode;
        this.blockErrorPageDescription = blockErrorPageDescription;
        this.maxArgumentCount = maxArgumentCount;
        this.maxNameLengthPerArgument = maxNameLengthPerArgument;
        this.maxTotalNameLengthOfArguments = maxTotalNameLengthOfArguments;
        this.recommendationsPeriodInDays = recommendationsPeriodInDays;
        this.isResponseInspected = isResponseInspected;
        this.maxResponseSizeInKiB = maxResponseSizeInKiB;
        this.allowedHttpMethods = allowedHttpMethods;
        this.mediaTypes = mediaTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public BlockAction getBlockAction() {
        return this.blockAction;
    }

    public Integer getBlockResponseCode() {
        return this.blockResponseCode;
    }

    public String getBlockErrorPageMessage() {
        return this.blockErrorPageMessage;
    }

    public String getBlockErrorPageCode() {
        return this.blockErrorPageCode;
    }

    public String getBlockErrorPageDescription() {
        return this.blockErrorPageDescription;
    }

    public Integer getMaxArgumentCount() {
        return this.maxArgumentCount;
    }

    public Integer getMaxNameLengthPerArgument() {
        return this.maxNameLengthPerArgument;
    }

    public Integer getMaxTotalNameLengthOfArguments() {
        return this.maxTotalNameLengthOfArguments;
    }

    public Integer getRecommendationsPeriodInDays() {
        return this.recommendationsPeriodInDays;
    }

    public Boolean getIsResponseInspected() {
        return this.isResponseInspected;
    }

    public Integer getMaxResponseSizeInKiB() {
        return this.maxResponseSizeInKiB;
    }

    public List<AllowedHttpMethods> getAllowedHttpMethods() {
        return this.allowedHttpMethods;
    }

    public List<String> getMediaTypes() {
        return this.mediaTypes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProtectionSettings(");
        sb.append("super=").append(super.toString());
        sb.append("blockAction=").append(String.valueOf((Object)this.blockAction));
        sb.append(", blockResponseCode=").append(String.valueOf(this.blockResponseCode));
        sb.append(", blockErrorPageMessage=").append(String.valueOf(this.blockErrorPageMessage));
        sb.append(", blockErrorPageCode=").append(String.valueOf(this.blockErrorPageCode));
        sb.append(", blockErrorPageDescription=").append(String.valueOf(this.blockErrorPageDescription));
        sb.append(", maxArgumentCount=").append(String.valueOf(this.maxArgumentCount));
        sb.append(", maxNameLengthPerArgument=").append(String.valueOf(this.maxNameLengthPerArgument));
        sb.append(", maxTotalNameLengthOfArguments=").append(String.valueOf(this.maxTotalNameLengthOfArguments));
        sb.append(", recommendationsPeriodInDays=").append(String.valueOf(this.recommendationsPeriodInDays));
        sb.append(", isResponseInspected=").append(String.valueOf(this.isResponseInspected));
        sb.append(", maxResponseSizeInKiB=").append(String.valueOf(this.maxResponseSizeInKiB));
        sb.append(", allowedHttpMethods=").append(String.valueOf(this.allowedHttpMethods));
        sb.append(", mediaTypes=").append(String.valueOf(this.mediaTypes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProtectionSettings)) {
            return false;
        }
        ProtectionSettings other = (ProtectionSettings)((Object)o);
        return Objects.equals((Object)this.blockAction, (Object)other.blockAction) && Objects.equals(this.blockResponseCode, other.blockResponseCode) && Objects.equals(this.blockErrorPageMessage, other.blockErrorPageMessage) && Objects.equals(this.blockErrorPageCode, other.blockErrorPageCode) && Objects.equals(this.blockErrorPageDescription, other.blockErrorPageDescription) && Objects.equals(this.maxArgumentCount, other.maxArgumentCount) && Objects.equals(this.maxNameLengthPerArgument, other.maxNameLengthPerArgument) && Objects.equals(this.maxTotalNameLengthOfArguments, other.maxTotalNameLengthOfArguments) && Objects.equals(this.recommendationsPeriodInDays, other.recommendationsPeriodInDays) && Objects.equals(this.isResponseInspected, other.isResponseInspected) && Objects.equals(this.maxResponseSizeInKiB, other.maxResponseSizeInKiB) && Objects.equals(this.allowedHttpMethods, other.allowedHttpMethods) && Objects.equals(this.mediaTypes, other.mediaTypes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.blockAction == null ? 43 : this.blockAction.hashCode());
        result = result * 59 + (this.blockResponseCode == null ? 43 : this.blockResponseCode.hashCode());
        result = result * 59 + (this.blockErrorPageMessage == null ? 43 : this.blockErrorPageMessage.hashCode());
        result = result * 59 + (this.blockErrorPageCode == null ? 43 : this.blockErrorPageCode.hashCode());
        result = result * 59 + (this.blockErrorPageDescription == null ? 43 : this.blockErrorPageDescription.hashCode());
        result = result * 59 + (this.maxArgumentCount == null ? 43 : this.maxArgumentCount.hashCode());
        result = result * 59 + (this.maxNameLengthPerArgument == null ? 43 : this.maxNameLengthPerArgument.hashCode());
        result = result * 59 + (this.maxTotalNameLengthOfArguments == null ? 43 : this.maxTotalNameLengthOfArguments.hashCode());
        result = result * 59 + (this.recommendationsPeriodInDays == null ? 43 : this.recommendationsPeriodInDays.hashCode());
        result = result * 59 + (this.isResponseInspected == null ? 43 : this.isResponseInspected.hashCode());
        result = result * 59 + (this.maxResponseSizeInKiB == null ? 43 : this.maxResponseSizeInKiB.hashCode());
        result = result * 59 + (this.allowedHttpMethods == null ? 43 : this.allowedHttpMethods.hashCode());
        result = result * 59 + (this.mediaTypes == null ? 43 : this.mediaTypes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AllowedHttpMethods implements BmcEnum
    {
        Options("OPTIONS"),
        Get("GET"),
        Head("HEAD"),
        Post("POST"),
        Put("PUT"),
        Delete("DELETE"),
        Trace("TRACE"),
        Connect("CONNECT"),
        Patch("PATCH"),
        Propfind("PROPFIND"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AllowedHttpMethods> map;

        private AllowedHttpMethods(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AllowedHttpMethods create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AllowedHttpMethods', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AllowedHttpMethods.class);
            map = new HashMap<String, AllowedHttpMethods>();
            for (AllowedHttpMethods v : AllowedHttpMethods.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum BlockAction implements BmcEnum
    {
        ShowErrorPage("SHOW_ERROR_PAGE"),
        SetResponseCode("SET_RESPONSE_CODE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BlockAction> map;

        private BlockAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BlockAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BlockAction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BlockAction.class);
            map = new HashMap<String, BlockAction>();
            for (BlockAction v : BlockAction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="blockAction")
        private BlockAction blockAction;
        @JsonProperty(value="blockResponseCode")
        private Integer blockResponseCode;
        @JsonProperty(value="blockErrorPageMessage")
        private String blockErrorPageMessage;
        @JsonProperty(value="blockErrorPageCode")
        private String blockErrorPageCode;
        @JsonProperty(value="blockErrorPageDescription")
        private String blockErrorPageDescription;
        @JsonProperty(value="maxArgumentCount")
        private Integer maxArgumentCount;
        @JsonProperty(value="maxNameLengthPerArgument")
        private Integer maxNameLengthPerArgument;
        @JsonProperty(value="maxTotalNameLengthOfArguments")
        private Integer maxTotalNameLengthOfArguments;
        @JsonProperty(value="recommendationsPeriodInDays")
        private Integer recommendationsPeriodInDays;
        @JsonProperty(value="isResponseInspected")
        private Boolean isResponseInspected;
        @JsonProperty(value="maxResponseSizeInKiB")
        private Integer maxResponseSizeInKiB;
        @JsonProperty(value="allowedHttpMethods")
        private List<AllowedHttpMethods> allowedHttpMethods;
        @JsonProperty(value="mediaTypes")
        private List<String> mediaTypes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder blockAction(BlockAction blockAction) {
            this.blockAction = blockAction;
            this.__explicitlySet__.add("blockAction");
            return this;
        }

        public Builder blockResponseCode(Integer blockResponseCode) {
            this.blockResponseCode = blockResponseCode;
            this.__explicitlySet__.add("blockResponseCode");
            return this;
        }

        public Builder blockErrorPageMessage(String blockErrorPageMessage) {
            this.blockErrorPageMessage = blockErrorPageMessage;
            this.__explicitlySet__.add("blockErrorPageMessage");
            return this;
        }

        public Builder blockErrorPageCode(String blockErrorPageCode) {
            this.blockErrorPageCode = blockErrorPageCode;
            this.__explicitlySet__.add("blockErrorPageCode");
            return this;
        }

        public Builder blockErrorPageDescription(String blockErrorPageDescription) {
            this.blockErrorPageDescription = blockErrorPageDescription;
            this.__explicitlySet__.add("blockErrorPageDescription");
            return this;
        }

        public Builder maxArgumentCount(Integer maxArgumentCount) {
            this.maxArgumentCount = maxArgumentCount;
            this.__explicitlySet__.add("maxArgumentCount");
            return this;
        }

        public Builder maxNameLengthPerArgument(Integer maxNameLengthPerArgument) {
            this.maxNameLengthPerArgument = maxNameLengthPerArgument;
            this.__explicitlySet__.add("maxNameLengthPerArgument");
            return this;
        }

        public Builder maxTotalNameLengthOfArguments(Integer maxTotalNameLengthOfArguments) {
            this.maxTotalNameLengthOfArguments = maxTotalNameLengthOfArguments;
            this.__explicitlySet__.add("maxTotalNameLengthOfArguments");
            return this;
        }

        public Builder recommendationsPeriodInDays(Integer recommendationsPeriodInDays) {
            this.recommendationsPeriodInDays = recommendationsPeriodInDays;
            this.__explicitlySet__.add("recommendationsPeriodInDays");
            return this;
        }

        public Builder isResponseInspected(Boolean isResponseInspected) {
            this.isResponseInspected = isResponseInspected;
            this.__explicitlySet__.add("isResponseInspected");
            return this;
        }

        public Builder maxResponseSizeInKiB(Integer maxResponseSizeInKiB) {
            this.maxResponseSizeInKiB = maxResponseSizeInKiB;
            this.__explicitlySet__.add("maxResponseSizeInKiB");
            return this;
        }

        public Builder allowedHttpMethods(List<AllowedHttpMethods> allowedHttpMethods) {
            this.allowedHttpMethods = allowedHttpMethods;
            this.__explicitlySet__.add("allowedHttpMethods");
            return this;
        }

        public Builder mediaTypes(List<String> mediaTypes) {
            this.mediaTypes = mediaTypes;
            this.__explicitlySet__.add("mediaTypes");
            return this;
        }

        public ProtectionSettings build() {
            ProtectionSettings model = new ProtectionSettings(this.blockAction, this.blockResponseCode, this.blockErrorPageMessage, this.blockErrorPageCode, this.blockErrorPageDescription, this.maxArgumentCount, this.maxNameLengthPerArgument, this.maxTotalNameLengthOfArguments, this.recommendationsPeriodInDays, this.isResponseInspected, this.maxResponseSizeInKiB, this.allowedHttpMethods, this.mediaTypes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProtectionSettings model) {
            if (model.wasPropertyExplicitlySet("blockAction")) {
                this.blockAction(model.getBlockAction());
            }
            if (model.wasPropertyExplicitlySet("blockResponseCode")) {
                this.blockResponseCode(model.getBlockResponseCode());
            }
            if (model.wasPropertyExplicitlySet("blockErrorPageMessage")) {
                this.blockErrorPageMessage(model.getBlockErrorPageMessage());
            }
            if (model.wasPropertyExplicitlySet("blockErrorPageCode")) {
                this.blockErrorPageCode(model.getBlockErrorPageCode());
            }
            if (model.wasPropertyExplicitlySet("blockErrorPageDescription")) {
                this.blockErrorPageDescription(model.getBlockErrorPageDescription());
            }
            if (model.wasPropertyExplicitlySet("maxArgumentCount")) {
                this.maxArgumentCount(model.getMaxArgumentCount());
            }
            if (model.wasPropertyExplicitlySet("maxNameLengthPerArgument")) {
                this.maxNameLengthPerArgument(model.getMaxNameLengthPerArgument());
            }
            if (model.wasPropertyExplicitlySet("maxTotalNameLengthOfArguments")) {
                this.maxTotalNameLengthOfArguments(model.getMaxTotalNameLengthOfArguments());
            }
            if (model.wasPropertyExplicitlySet("recommendationsPeriodInDays")) {
                this.recommendationsPeriodInDays(model.getRecommendationsPeriodInDays());
            }
            if (model.wasPropertyExplicitlySet("isResponseInspected")) {
                this.isResponseInspected(model.getIsResponseInspected());
            }
            if (model.wasPropertyExplicitlySet("maxResponseSizeInKiB")) {
                this.maxResponseSizeInKiB(model.getMaxResponseSizeInKiB());
            }
            if (model.wasPropertyExplicitlySet("allowedHttpMethods")) {
                this.allowedHttpMethods(model.getAllowedHttpMethods());
            }
            if (model.wasPropertyExplicitlySet("mediaTypes")) {
                this.mediaTypes(model.getMediaTypes());
            }
            return this;
        }
    }
}

