/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.waas.model.Header;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Origin
extends ExplicitlySetBmcModel {
    @JsonProperty(value="uri")
    private final String uri;
    @JsonProperty(value="httpPort")
    private final Integer httpPort;
    @JsonProperty(value="httpsPort")
    private final Integer httpsPort;
    @JsonProperty(value="customHeaders")
    private final List<Header> customHeaders;

    @Deprecated
    @ConstructorProperties(value={"uri", "httpPort", "httpsPort", "customHeaders"})
    public Origin(String uri, Integer httpPort, Integer httpsPort, List<Header> customHeaders) {
        this.uri = uri;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.customHeaders = customHeaders;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getUri() {
        return this.uri;
    }

    public Integer getHttpPort() {
        return this.httpPort;
    }

    public Integer getHttpsPort() {
        return this.httpsPort;
    }

    public List<Header> getCustomHeaders() {
        return this.customHeaders;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Origin(");
        sb.append("super=").append(super.toString());
        sb.append("uri=").append(String.valueOf(this.uri));
        sb.append(", httpPort=").append(String.valueOf(this.httpPort));
        sb.append(", httpsPort=").append(String.valueOf(this.httpsPort));
        sb.append(", customHeaders=").append(String.valueOf(this.customHeaders));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Origin)) {
            return false;
        }
        Origin other = (Origin)((Object)o);
        return Objects.equals(this.uri, other.uri) && Objects.equals(this.httpPort, other.httpPort) && Objects.equals(this.httpsPort, other.httpsPort) && Objects.equals(this.customHeaders, other.customHeaders) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.uri == null ? 43 : this.uri.hashCode());
        result = result * 59 + (this.httpPort == null ? 43 : this.httpPort.hashCode());
        result = result * 59 + (this.httpsPort == null ? 43 : this.httpsPort.hashCode());
        result = result * 59 + (this.customHeaders == null ? 43 : this.customHeaders.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="uri")
        private String uri;
        @JsonProperty(value="httpPort")
        private Integer httpPort;
        @JsonProperty(value="httpsPort")
        private Integer httpsPort;
        @JsonProperty(value="customHeaders")
        private List<Header> customHeaders;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder uri(String uri) {
            this.uri = uri;
            this.__explicitlySet__.add("uri");
            return this;
        }

        public Builder httpPort(Integer httpPort) {
            this.httpPort = httpPort;
            this.__explicitlySet__.add("httpPort");
            return this;
        }

        public Builder httpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
            this.__explicitlySet__.add("httpsPort");
            return this;
        }

        public Builder customHeaders(List<Header> customHeaders) {
            this.customHeaders = customHeaders;
            this.__explicitlySet__.add("customHeaders");
            return this;
        }

        public Origin build() {
            Origin model = new Origin(this.uri, this.httpPort, this.httpsPort, this.customHeaders);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Origin model) {
            if (model.wasPropertyExplicitlySet("uri")) {
                this.uri(model.getUri());
            }
            if (model.wasPropertyExplicitlySet("httpPort")) {
                this.httpPort(model.getHttpPort());
            }
            if (model.wasPropertyExplicitlySet("httpsPort")) {
                this.httpsPort(model.getHttpsPort());
            }
            if (model.wasPropertyExplicitlySet("customHeaders")) {
                this.customHeaders(model.getCustomHeaders());
            }
            return this;
        }
    }
}

