/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Certificate_publicKeyInfo
extends ExplicitlySetBmcModel {
    @JsonProperty(value="algorithm")
    private final String algorithm;
    @JsonProperty(value="exponent")
    private final Integer exponent;
    @JsonProperty(value="keySize")
    private final Integer keySize;

    @Deprecated
    @ConstructorProperties(value={"algorithm", "exponent", "keySize"})
    public Certificate_publicKeyInfo(String algorithm, Integer exponent, Integer keySize) {
        this.algorithm = algorithm;
        this.exponent = exponent;
        this.keySize = keySize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Integer getExponent() {
        return this.exponent;
    }

    public Integer getKeySize() {
        return this.keySize;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Certificate_publicKeyInfo(");
        sb.append("super=").append(super.toString());
        sb.append("algorithm=").append(String.valueOf(this.algorithm));
        sb.append(", exponent=").append(String.valueOf(this.exponent));
        sb.append(", keySize=").append(String.valueOf(this.keySize));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Certificate_publicKeyInfo)) {
            return false;
        }
        Certificate_publicKeyInfo other = (Certificate_publicKeyInfo)((Object)o);
        return Objects.equals(this.algorithm, other.algorithm) && Objects.equals(this.exponent, other.exponent) && Objects.equals(this.keySize, other.keySize) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.algorithm == null ? 43 : this.algorithm.hashCode());
        result = result * 59 + (this.exponent == null ? 43 : this.exponent.hashCode());
        result = result * 59 + (this.keySize == null ? 43 : this.keySize.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="algorithm")
        private String algorithm;
        @JsonProperty(value="exponent")
        private Integer exponent;
        @JsonProperty(value="keySize")
        private Integer keySize;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            this.__explicitlySet__.add("algorithm");
            return this;
        }

        public Builder exponent(Integer exponent) {
            this.exponent = exponent;
            this.__explicitlySet__.add("exponent");
            return this;
        }

        public Builder keySize(Integer keySize) {
            this.keySize = keySize;
            this.__explicitlySet__.add("keySize");
            return this;
        }

        public Certificate_publicKeyInfo build() {
            Certificate_publicKeyInfo model = new Certificate_publicKeyInfo(this.algorithm, this.exponent, this.keySize);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Certificate_publicKeyInfo model) {
            if (model.wasPropertyExplicitlySet("algorithm")) {
                this.algorithm(model.getAlgorithm());
            }
            if (model.wasPropertyExplicitlySet("exponent")) {
                this.exponent(model.getExponent());
            }
            if (model.wasPropertyExplicitlySet("keySize")) {
                this.keySize(model.getKeySize());
            }
            return this;
        }
    }
}

