/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Captcha
extends ExplicitlySetBmcModel {
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="sessionExpirationInSeconds")
    private final Integer sessionExpirationInSeconds;
    @JsonProperty(value="title")
    private final String title;
    @JsonProperty(value="headerText")
    private final String headerText;
    @JsonProperty(value="footerText")
    private final String footerText;
    @JsonProperty(value="failureMessage")
    private final String failureMessage;
    @JsonProperty(value="submitLabel")
    private final String submitLabel;

    @Deprecated
    @ConstructorProperties(value={"url", "sessionExpirationInSeconds", "title", "headerText", "footerText", "failureMessage", "submitLabel"})
    public Captcha(String url, Integer sessionExpirationInSeconds, String title, String headerText, String footerText, String failureMessage, String submitLabel) {
        this.url = url;
        this.sessionExpirationInSeconds = sessionExpirationInSeconds;
        this.title = title;
        this.headerText = headerText;
        this.footerText = footerText;
        this.failureMessage = failureMessage;
        this.submitLabel = submitLabel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getSessionExpirationInSeconds() {
        return this.sessionExpirationInSeconds;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public String getFooterText() {
        return this.footerText;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public String getSubmitLabel() {
        return this.submitLabel;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Captcha(");
        sb.append("super=").append(super.toString());
        sb.append("url=").append(String.valueOf(this.url));
        sb.append(", sessionExpirationInSeconds=").append(String.valueOf(this.sessionExpirationInSeconds));
        sb.append(", title=").append(String.valueOf(this.title));
        sb.append(", headerText=").append(String.valueOf(this.headerText));
        sb.append(", footerText=").append(String.valueOf(this.footerText));
        sb.append(", failureMessage=").append(String.valueOf(this.failureMessage));
        sb.append(", submitLabel=").append(String.valueOf(this.submitLabel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Captcha)) {
            return false;
        }
        Captcha other = (Captcha)((Object)o);
        return Objects.equals(this.url, other.url) && Objects.equals(this.sessionExpirationInSeconds, other.sessionExpirationInSeconds) && Objects.equals(this.title, other.title) && Objects.equals(this.headerText, other.headerText) && Objects.equals(this.footerText, other.footerText) && Objects.equals(this.failureMessage, other.failureMessage) && Objects.equals(this.submitLabel, other.submitLabel) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.sessionExpirationInSeconds == null ? 43 : this.sessionExpirationInSeconds.hashCode());
        result = result * 59 + (this.title == null ? 43 : this.title.hashCode());
        result = result * 59 + (this.headerText == null ? 43 : this.headerText.hashCode());
        result = result * 59 + (this.footerText == null ? 43 : this.footerText.hashCode());
        result = result * 59 + (this.failureMessage == null ? 43 : this.failureMessage.hashCode());
        result = result * 59 + (this.submitLabel == null ? 43 : this.submitLabel.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="sessionExpirationInSeconds")
        private Integer sessionExpirationInSeconds;
        @JsonProperty(value="title")
        private String title;
        @JsonProperty(value="headerText")
        private String headerText;
        @JsonProperty(value="footerText")
        private String footerText;
        @JsonProperty(value="failureMessage")
        private String failureMessage;
        @JsonProperty(value="submitLabel")
        private String submitLabel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public Builder sessionExpirationInSeconds(Integer sessionExpirationInSeconds) {
            this.sessionExpirationInSeconds = sessionExpirationInSeconds;
            this.__explicitlySet__.add("sessionExpirationInSeconds");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.__explicitlySet__.add("title");
            return this;
        }

        public Builder headerText(String headerText) {
            this.headerText = headerText;
            this.__explicitlySet__.add("headerText");
            return this;
        }

        public Builder footerText(String footerText) {
            this.footerText = footerText;
            this.__explicitlySet__.add("footerText");
            return this;
        }

        public Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            this.__explicitlySet__.add("failureMessage");
            return this;
        }

        public Builder submitLabel(String submitLabel) {
            this.submitLabel = submitLabel;
            this.__explicitlySet__.add("submitLabel");
            return this;
        }

        public Captcha build() {
            Captcha model = new Captcha(this.url, this.sessionExpirationInSeconds, this.title, this.headerText, this.footerText, this.failureMessage, this.submitLabel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Captcha model) {
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            if (model.wasPropertyExplicitlySet("sessionExpirationInSeconds")) {
                this.sessionExpirationInSeconds(model.getSessionExpirationInSeconds());
            }
            if (model.wasPropertyExplicitlySet("title")) {
                this.title(model.getTitle());
            }
            if (model.wasPropertyExplicitlySet("headerText")) {
                this.headerText(model.getHeaderText());
            }
            if (model.wasPropertyExplicitlySet("footerText")) {
                this.footerText(model.getFooterText());
            }
            if (model.wasPropertyExplicitlySet("failureMessage")) {
                this.failureMessage(model.getFailureMessage());
            }
            if (model.wasPropertyExplicitlySet("submitLabel")) {
                this.submitLabel(model.getSubmitLabel());
            }
            return this;
        }
    }
}

