/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.waas.Redirect;
import com.oracle.bmc.waas.model.HttpRedirectSummary;
import com.oracle.bmc.waas.requests.ListHttpRedirectsRequest;
import com.oracle.bmc.waas.responses.ListHttpRedirectsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class RedirectPaginators {
    private final Redirect client;

    public RedirectPaginators(Redirect client) {
        this.client = client;
    }

    public Iterable<ListHttpRedirectsResponse> listHttpRedirectsResponseIterator(final ListHttpRedirectsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListHttpRedirectsRequest.Builder>(){

            @Override
            public ListHttpRedirectsRequest.Builder get() {
                return ListHttpRedirectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHttpRedirectsResponse, String>(){

            @Override
            public String apply(ListHttpRedirectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHttpRedirectsRequest.Builder>, ListHttpRedirectsRequest>(){

            @Override
            public ListHttpRedirectsRequest apply(RequestBuilderAndToken<ListHttpRedirectsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHttpRedirectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHttpRedirectsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHttpRedirectsRequest, ListHttpRedirectsResponse>(){

            @Override
            public ListHttpRedirectsResponse apply(ListHttpRedirectsRequest request) {
                return RedirectPaginators.this.client.listHttpRedirects(request);
            }
        });
    }

    public Iterable<HttpRedirectSummary> listHttpRedirectsRecordIterator(final ListHttpRedirectsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListHttpRedirectsRequest.Builder>(){

            @Override
            public ListHttpRedirectsRequest.Builder get() {
                return ListHttpRedirectsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListHttpRedirectsResponse, String>(){

            @Override
            public String apply(ListHttpRedirectsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListHttpRedirectsRequest.Builder>, ListHttpRedirectsRequest>(){

            @Override
            public ListHttpRedirectsRequest apply(RequestBuilderAndToken<ListHttpRedirectsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListHttpRedirectsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListHttpRedirectsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListHttpRedirectsRequest, ListHttpRedirectsResponse>(){

            @Override
            public ListHttpRedirectsResponse apply(ListHttpRedirectsRequest request) {
                return RedirectPaginators.this.client.listHttpRedirects(request);
            }
        }, (Function)new Function<ListHttpRedirectsResponse, List<HttpRedirectSummary>>(){

            @Override
            public List<HttpRedirectSummary> apply(ListHttpRedirectsResponse response) {
                return response.getItems();
            }
        });
    }
}

