/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waa.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetWebAppAccelerationRequest
extends BmcRequest<Void> {
    private String webAppAccelerationId;
    private String opcRequestId;

    public String getWebAppAccelerationId() {
        return this.webAppAccelerationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().webAppAccelerationId(this.webAppAccelerationId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",webAppAccelerationId=").append(String.valueOf(this.webAppAccelerationId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetWebAppAccelerationRequest)) {
            return false;
        }
        GetWebAppAccelerationRequest other = (GetWebAppAccelerationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.webAppAccelerationId, other.webAppAccelerationId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.webAppAccelerationId == null ? 43 : this.webAppAccelerationId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetWebAppAccelerationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String webAppAccelerationId = null;
        private String opcRequestId = null;

        public Builder webAppAccelerationId(String webAppAccelerationId) {
            this.webAppAccelerationId = webAppAccelerationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetWebAppAccelerationRequest o) {
            this.webAppAccelerationId(o.getWebAppAccelerationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetWebAppAccelerationRequest build() {
            GetWebAppAccelerationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetWebAppAccelerationRequest buildWithoutInvocationCallback() {
            GetWebAppAccelerationRequest request = new GetWebAppAccelerationRequest();
            request.webAppAccelerationId = this.webAppAccelerationId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

