/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waa;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.waa.Waa;
import com.oracle.bmc.waa.model.WebAppAccelerationPolicySummary;
import com.oracle.bmc.waa.model.WebAppAccelerationSummary;
import com.oracle.bmc.waa.requests.ListWebAppAccelerationPoliciesRequest;
import com.oracle.bmc.waa.requests.ListWebAppAccelerationsRequest;
import com.oracle.bmc.waa.responses.ListWebAppAccelerationPoliciesResponse;
import com.oracle.bmc.waa.responses.ListWebAppAccelerationsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class WaaPaginators {
    private final Waa client;

    public WaaPaginators(Waa client) {
        this.client = client;
    }

    public Iterable<ListWebAppAccelerationPoliciesResponse> listWebAppAccelerationPoliciesResponseIterator(final ListWebAppAccelerationPoliciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWebAppAccelerationPoliciesRequest.Builder>(){

            @Override
            public ListWebAppAccelerationPoliciesRequest.Builder get() {
                return ListWebAppAccelerationPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWebAppAccelerationPoliciesResponse, String>(){

            @Override
            public String apply(ListWebAppAccelerationPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWebAppAccelerationPoliciesRequest.Builder>, ListWebAppAccelerationPoliciesRequest>(){

            @Override
            public ListWebAppAccelerationPoliciesRequest apply(RequestBuilderAndToken<ListWebAppAccelerationPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWebAppAccelerationPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWebAppAccelerationPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWebAppAccelerationPoliciesRequest, ListWebAppAccelerationPoliciesResponse>(){

            @Override
            public ListWebAppAccelerationPoliciesResponse apply(ListWebAppAccelerationPoliciesRequest request) {
                return WaaPaginators.this.client.listWebAppAccelerationPolicies(request);
            }
        });
    }

    public Iterable<WebAppAccelerationPolicySummary> listWebAppAccelerationPoliciesRecordIterator(final ListWebAppAccelerationPoliciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWebAppAccelerationPoliciesRequest.Builder>(){

            @Override
            public ListWebAppAccelerationPoliciesRequest.Builder get() {
                return ListWebAppAccelerationPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWebAppAccelerationPoliciesResponse, String>(){

            @Override
            public String apply(ListWebAppAccelerationPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWebAppAccelerationPoliciesRequest.Builder>, ListWebAppAccelerationPoliciesRequest>(){

            @Override
            public ListWebAppAccelerationPoliciesRequest apply(RequestBuilderAndToken<ListWebAppAccelerationPoliciesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWebAppAccelerationPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWebAppAccelerationPoliciesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWebAppAccelerationPoliciesRequest, ListWebAppAccelerationPoliciesResponse>(){

            @Override
            public ListWebAppAccelerationPoliciesResponse apply(ListWebAppAccelerationPoliciesRequest request) {
                return WaaPaginators.this.client.listWebAppAccelerationPolicies(request);
            }
        }, (Function)new Function<ListWebAppAccelerationPoliciesResponse, List<WebAppAccelerationPolicySummary>>(){

            @Override
            public List<WebAppAccelerationPolicySummary> apply(ListWebAppAccelerationPoliciesResponse response) {
                return response.getWebAppAccelerationPolicyCollection().getItems();
            }
        });
    }

    public Iterable<ListWebAppAccelerationsResponse> listWebAppAccelerationsResponseIterator(final ListWebAppAccelerationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWebAppAccelerationsRequest.Builder>(){

            @Override
            public ListWebAppAccelerationsRequest.Builder get() {
                return ListWebAppAccelerationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWebAppAccelerationsResponse, String>(){

            @Override
            public String apply(ListWebAppAccelerationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWebAppAccelerationsRequest.Builder>, ListWebAppAccelerationsRequest>(){

            @Override
            public ListWebAppAccelerationsRequest apply(RequestBuilderAndToken<ListWebAppAccelerationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWebAppAccelerationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWebAppAccelerationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWebAppAccelerationsRequest, ListWebAppAccelerationsResponse>(){

            @Override
            public ListWebAppAccelerationsResponse apply(ListWebAppAccelerationsRequest request) {
                return WaaPaginators.this.client.listWebAppAccelerations(request);
            }
        });
    }

    public Iterable<WebAppAccelerationSummary> listWebAppAccelerationsRecordIterator(final ListWebAppAccelerationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWebAppAccelerationsRequest.Builder>(){

            @Override
            public ListWebAppAccelerationsRequest.Builder get() {
                return ListWebAppAccelerationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWebAppAccelerationsResponse, String>(){

            @Override
            public String apply(ListWebAppAccelerationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWebAppAccelerationsRequest.Builder>, ListWebAppAccelerationsRequest>(){

            @Override
            public ListWebAppAccelerationsRequest apply(RequestBuilderAndToken<ListWebAppAccelerationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWebAppAccelerationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWebAppAccelerationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWebAppAccelerationsRequest, ListWebAppAccelerationsResponse>(){

            @Override
            public ListWebAppAccelerationsResponse apply(ListWebAppAccelerationsRequest request) {
                return WaaPaginators.this.client.listWebAppAccelerations(request);
            }
        }, (Function)new Function<ListWebAppAccelerationsResponse, List<WebAppAccelerationSummary>>(){

            @Override
            public List<WebAppAccelerationSummary> apply(ListWebAppAccelerationsResponse response) {
                return response.getWebAppAccelerationCollection().getItems();
            }
        });
    }
}

