/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.vulnerabilityscanning.model.HostEndpointProtectionScanResultSortBy;
import com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity;
import com.oracle.bmc.vulnerabilityscanning.model.SortOrder;
import java.util.Date;
import java.util.Objects;

public class ListHostEndpointProtectionScanResultsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String instanceId;
    private ScanResultProblemSeverity highestProblemSeverity;
    private Date timeStartedGreaterThanOrEqualTo;
    private Date timeStartedLessThanOrEqualTo;
    private SortOrder sortOrder;
    private HostEndpointProtectionScanResultSortBy sortBy;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private String displayName;
    private Boolean isLatestOnly;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ScanResultProblemSeverity getHighestProblemSeverity() {
        return this.highestProblemSeverity;
    }

    public Date getTimeStartedGreaterThanOrEqualTo() {
        return this.timeStartedGreaterThanOrEqualTo;
    }

    public Date getTimeStartedLessThanOrEqualTo() {
        return this.timeStartedLessThanOrEqualTo;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public HostEndpointProtectionScanResultSortBy getSortBy() {
        return this.sortBy;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean getIsLatestOnly() {
        return this.isLatestOnly;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).instanceId(this.instanceId).highestProblemSeverity(this.highestProblemSeverity).timeStartedGreaterThanOrEqualTo(this.timeStartedGreaterThanOrEqualTo).timeStartedLessThanOrEqualTo(this.timeStartedLessThanOrEqualTo).sortOrder(this.sortOrder).sortBy(this.sortBy).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).displayName(this.displayName).isLatestOnly(this.isLatestOnly);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",instanceId=").append(String.valueOf(this.instanceId));
        sb.append(",highestProblemSeverity=").append(String.valueOf((Object)this.highestProblemSeverity));
        sb.append(",timeStartedGreaterThanOrEqualTo=").append(String.valueOf(this.timeStartedGreaterThanOrEqualTo));
        sb.append(",timeStartedLessThanOrEqualTo=").append(String.valueOf(this.timeStartedLessThanOrEqualTo));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",isLatestOnly=").append(String.valueOf(this.isLatestOnly));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListHostEndpointProtectionScanResultsRequest)) {
            return false;
        }
        ListHostEndpointProtectionScanResultsRequest other = (ListHostEndpointProtectionScanResultsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals((Object)this.highestProblemSeverity, (Object)other.highestProblemSeverity) && Objects.equals(this.timeStartedGreaterThanOrEqualTo, other.timeStartedGreaterThanOrEqualTo) && Objects.equals(this.timeStartedLessThanOrEqualTo, other.timeStartedLessThanOrEqualTo) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.isLatestOnly, other.isLatestOnly);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.highestProblemSeverity == null ? 43 : this.highestProblemSeverity.hashCode());
        result = result * 59 + (this.timeStartedGreaterThanOrEqualTo == null ? 43 : this.timeStartedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeStartedLessThanOrEqualTo == null ? 43 : this.timeStartedLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.isLatestOnly == null ? 43 : this.isLatestOnly.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListHostEndpointProtectionScanResultsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String instanceId = null;
        private ScanResultProblemSeverity highestProblemSeverity = null;
        private Date timeStartedGreaterThanOrEqualTo = null;
        private Date timeStartedLessThanOrEqualTo = null;
        private SortOrder sortOrder = null;
        private HostEndpointProtectionScanResultSortBy sortBy = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;
        private String displayName = null;
        private Boolean isLatestOnly = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder highestProblemSeverity(ScanResultProblemSeverity highestProblemSeverity) {
            this.highestProblemSeverity = highestProblemSeverity;
            return this;
        }

        public Builder timeStartedGreaterThanOrEqualTo(Date timeStartedGreaterThanOrEqualTo) {
            this.timeStartedGreaterThanOrEqualTo = timeStartedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeStartedLessThanOrEqualTo(Date timeStartedLessThanOrEqualTo) {
            this.timeStartedLessThanOrEqualTo = timeStartedLessThanOrEqualTo;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(HostEndpointProtectionScanResultSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder isLatestOnly(Boolean isLatestOnly) {
            this.isLatestOnly = isLatestOnly;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListHostEndpointProtectionScanResultsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.instanceId(o.getInstanceId());
            this.highestProblemSeverity(o.getHighestProblemSeverity());
            this.timeStartedGreaterThanOrEqualTo(o.getTimeStartedGreaterThanOrEqualTo());
            this.timeStartedLessThanOrEqualTo(o.getTimeStartedLessThanOrEqualTo());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.displayName(o.getDisplayName());
            this.isLatestOnly(o.getIsLatestOnly());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListHostEndpointProtectionScanResultsRequest build() {
            ListHostEndpointProtectionScanResultsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListHostEndpointProtectionScanResultsRequest buildWithoutInvocationCallback() {
            ListHostEndpointProtectionScanResultsRequest request = new ListHostEndpointProtectionScanResultsRequest();
            request.compartmentId = this.compartmentId;
            request.instanceId = this.instanceId;
            request.highestProblemSeverity = this.highestProblemSeverity;
            request.timeStartedGreaterThanOrEqualTo = this.timeStartedGreaterThanOrEqualTo;
            request.timeStartedLessThanOrEqualTo = this.timeStartedLessThanOrEqualTo;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.displayName = this.displayName;
            request.isLatestOnly = this.isLatestOnly;
            return request;
        }
    }
}

