/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.vulnerabilityscanning.model.ContainerScanResultSortBy;
import com.oracle.bmc.vulnerabilityscanning.model.ScanResultProblemSeverity;
import com.oracle.bmc.vulnerabilityscanning.model.SortOrder;
import java.util.Date;
import java.util.Objects;

public class ListContainerScanResultsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String repository;
    private String image;
    private Boolean areSubcompartmentsIncluded;
    private ScanResultProblemSeverity highestProblemSeverity;
    private Date timeStartedGreaterThanOrEqualTo;
    private Date timeStartedLessThanOrEqualTo;
    private SortOrder sortOrder;
    private ContainerScanResultSortBy sortBy;
    private Integer limit;
    private String page;
    private String opcRequestId;
    private Boolean isLatestOnly;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getImage() {
        return this.image;
    }

    public Boolean getAreSubcompartmentsIncluded() {
        return this.areSubcompartmentsIncluded;
    }

    public ScanResultProblemSeverity getHighestProblemSeverity() {
        return this.highestProblemSeverity;
    }

    public Date getTimeStartedGreaterThanOrEqualTo() {
        return this.timeStartedGreaterThanOrEqualTo;
    }

    public Date getTimeStartedLessThanOrEqualTo() {
        return this.timeStartedLessThanOrEqualTo;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public ContainerScanResultSortBy getSortBy() {
        return this.sortBy;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsLatestOnly() {
        return this.isLatestOnly;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).repository(this.repository).image(this.image).areSubcompartmentsIncluded(this.areSubcompartmentsIncluded).highestProblemSeverity(this.highestProblemSeverity).timeStartedGreaterThanOrEqualTo(this.timeStartedGreaterThanOrEqualTo).timeStartedLessThanOrEqualTo(this.timeStartedLessThanOrEqualTo).sortOrder(this.sortOrder).sortBy(this.sortBy).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId).isLatestOnly(this.isLatestOnly);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",repository=").append(String.valueOf(this.repository));
        sb.append(",image=").append(String.valueOf(this.image));
        sb.append(",areSubcompartmentsIncluded=").append(String.valueOf(this.areSubcompartmentsIncluded));
        sb.append(",highestProblemSeverity=").append(String.valueOf((Object)this.highestProblemSeverity));
        sb.append(",timeStartedGreaterThanOrEqualTo=").append(String.valueOf(this.timeStartedGreaterThanOrEqualTo));
        sb.append(",timeStartedLessThanOrEqualTo=").append(String.valueOf(this.timeStartedLessThanOrEqualTo));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isLatestOnly=").append(String.valueOf(this.isLatestOnly));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListContainerScanResultsRequest)) {
            return false;
        }
        ListContainerScanResultsRequest other = (ListContainerScanResultsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.repository, other.repository) && Objects.equals(this.image, other.image) && Objects.equals(this.areSubcompartmentsIncluded, other.areSubcompartmentsIncluded) && Objects.equals((Object)this.highestProblemSeverity, (Object)other.highestProblemSeverity) && Objects.equals(this.timeStartedGreaterThanOrEqualTo, other.timeStartedGreaterThanOrEqualTo) && Objects.equals(this.timeStartedLessThanOrEqualTo, other.timeStartedLessThanOrEqualTo) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isLatestOnly, other.isLatestOnly);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.repository == null ? 43 : this.repository.hashCode());
        result = result * 59 + (this.image == null ? 43 : this.image.hashCode());
        result = result * 59 + (this.areSubcompartmentsIncluded == null ? 43 : this.areSubcompartmentsIncluded.hashCode());
        result = result * 59 + (this.highestProblemSeverity == null ? 43 : this.highestProblemSeverity.hashCode());
        result = result * 59 + (this.timeStartedGreaterThanOrEqualTo == null ? 43 : this.timeStartedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeStartedLessThanOrEqualTo == null ? 43 : this.timeStartedLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isLatestOnly == null ? 43 : this.isLatestOnly.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListContainerScanResultsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private String repository = null;
        private String image = null;
        private Boolean areSubcompartmentsIncluded = null;
        private ScanResultProblemSeverity highestProblemSeverity = null;
        private Date timeStartedGreaterThanOrEqualTo = null;
        private Date timeStartedLessThanOrEqualTo = null;
        private SortOrder sortOrder = null;
        private ContainerScanResultSortBy sortBy = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;
        private Boolean isLatestOnly = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder image(String image) {
            this.image = image;
            return this;
        }

        public Builder areSubcompartmentsIncluded(Boolean areSubcompartmentsIncluded) {
            this.areSubcompartmentsIncluded = areSubcompartmentsIncluded;
            return this;
        }

        public Builder highestProblemSeverity(ScanResultProblemSeverity highestProblemSeverity) {
            this.highestProblemSeverity = highestProblemSeverity;
            return this;
        }

        public Builder timeStartedGreaterThanOrEqualTo(Date timeStartedGreaterThanOrEqualTo) {
            this.timeStartedGreaterThanOrEqualTo = timeStartedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeStartedLessThanOrEqualTo(Date timeStartedLessThanOrEqualTo) {
            this.timeStartedLessThanOrEqualTo = timeStartedLessThanOrEqualTo;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(ContainerScanResultSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isLatestOnly(Boolean isLatestOnly) {
            this.isLatestOnly = isLatestOnly;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListContainerScanResultsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.repository(o.getRepository());
            this.image(o.getImage());
            this.areSubcompartmentsIncluded(o.getAreSubcompartmentsIncluded());
            this.highestProblemSeverity(o.getHighestProblemSeverity());
            this.timeStartedGreaterThanOrEqualTo(o.getTimeStartedGreaterThanOrEqualTo());
            this.timeStartedLessThanOrEqualTo(o.getTimeStartedLessThanOrEqualTo());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.isLatestOnly(o.getIsLatestOnly());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListContainerScanResultsRequest build() {
            ListContainerScanResultsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListContainerScanResultsRequest buildWithoutInvocationCallback() {
            ListContainerScanResultsRequest request = new ListContainerScanResultsRequest();
            request.compartmentId = this.compartmentId;
            request.repository = this.repository;
            request.image = this.image;
            request.areSubcompartmentsIncluded = this.areSubcompartmentsIncluded;
            request.highestProblemSeverity = this.highestProblemSeverity;
            request.timeStartedGreaterThanOrEqualTo = this.timeStartedGreaterThanOrEqualTo;
            request.timeStartedLessThanOrEqualTo = this.timeStartedLessThanOrEqualTo;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.isLatestOnly = this.isLatestOnly;
            return request;
        }
    }
}

