/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetContainerScanTargetRequest
extends BmcRequest<Void> {
    private String containerScanTargetId;
    private String opcRequestId;

    public String getContainerScanTargetId() {
        return this.containerScanTargetId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().containerScanTargetId(this.containerScanTargetId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",containerScanTargetId=").append(String.valueOf(this.containerScanTargetId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetContainerScanTargetRequest)) {
            return false;
        }
        GetContainerScanTargetRequest other = (GetContainerScanTargetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.containerScanTargetId, other.containerScanTargetId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.containerScanTargetId == null ? 43 : this.containerScanTargetId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetContainerScanTargetRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String containerScanTargetId = null;
        private String opcRequestId = null;

        public Builder containerScanTargetId(String containerScanTargetId) {
            this.containerScanTargetId = containerScanTargetId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetContainerScanTargetRequest o) {
            this.containerScanTargetId(o.getContainerScanTargetId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetContainerScanTargetRequest build() {
            GetContainerScanTargetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetContainerScanTargetRequest buildWithoutInvocationCallback() {
            GetContainerScanTargetRequest request = new GetContainerScanTargetRequest();
            request.containerScanTargetId = this.containerScanTargetId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

