/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetContainerScanResultRequest
extends BmcRequest<Void> {
    private String containerScanResultId;
    private String opcRequestId;

    public String getContainerScanResultId() {
        return this.containerScanResultId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().containerScanResultId(this.containerScanResultId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",containerScanResultId=").append(String.valueOf(this.containerScanResultId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetContainerScanResultRequest)) {
            return false;
        }
        GetContainerScanResultRequest other = (GetContainerScanResultRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.containerScanResultId, other.containerScanResultId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.containerScanResultId == null ? 43 : this.containerScanResultId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetContainerScanResultRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String containerScanResultId = null;
        private String opcRequestId = null;

        public Builder containerScanResultId(String containerScanResultId) {
            this.containerScanResultId = containerScanResultId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetContainerScanResultRequest o) {
            this.containerScanResultId(o.getContainerScanResultId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetContainerScanResultRequest build() {
            GetContainerScanResultRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetContainerScanResultRequest buildWithoutInvocationCallback() {
            GetContainerScanResultRequest request = new GetContainerScanResultRequest();
            request.containerScanResultId = this.containerScanResultId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

