/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vulnerabilityscanning.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Package
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="cveFixVersion")
    private final String cveFixVersion;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="locations")
    private final List<String> locations;

    @Deprecated
    @ConstructorProperties(value={"name", "version", "cveFixVersion", "type", "locations"})
    public Package(String name, String version, String cveFixVersion, Type type, List<String> locations) {
        this.name = name;
        this.version = version;
        this.cveFixVersion = cveFixVersion;
        this.type = type;
        this.locations = locations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCveFixVersion() {
        return this.cveFixVersion;
    }

    public Type getType() {
        return this.type;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Package(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", cveFixVersion=").append(String.valueOf(this.cveFixVersion));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", locations=").append(String.valueOf(this.locations));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Package)) {
            return false;
        }
        Package other = (Package)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.cveFixVersion, other.cveFixVersion) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.locations, other.locations) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.cveFixVersion == null ? 43 : this.cveFixVersion.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.locations == null ? 43 : this.locations.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Java("JAVA"),
        Apk("APK"),
        Rpm("RPM"),
        Deb("DEB"),
        Go("GO"),
        Npm("NPM"),
        Python("PYTHON"),
        Rust("RUST"),
        PhpComposer("PHP_COMPOSER"),
        Gem("GEM"),
        MsrcKb("MSRC_KB"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="cveFixVersion")
        private String cveFixVersion;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="locations")
        private List<String> locations;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder cveFixVersion(String cveFixVersion) {
            this.cveFixVersion = cveFixVersion;
            this.__explicitlySet__.add("cveFixVersion");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder locations(List<String> locations) {
            this.locations = locations;
            this.__explicitlySet__.add("locations");
            return this;
        }

        public Package build() {
            Package model = new Package(this.name, this.version, this.cveFixVersion, this.type, this.locations);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Package model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("cveFixVersion")) {
                this.cveFixVersion(model.getCveFixVersion());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("locations")) {
                this.locations(model.getLocations());
            }
            return this;
        }
    }
}

